/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeSpec;
import io.requery.Entity;
import io.requery.ForeignKey;
import io.requery.Key;
import io.requery.ReferentialAction;
import io.requery.Table;
import io.requery.processor.AssociativeEntityDescriptor;
import io.requery.processor.AssociativeReference;
import io.requery.processor.AttributeDescriptor;
import io.requery.processor.CodeGeneration;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.EntityNameResolver;
import io.requery.processor.Names;
import io.requery.processor.SourceGenerator;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

class JoinEntityGenerator
implements SourceGenerator {
    private final ProcessingEnvironment processingEnvironment;
    private final EntityNameResolver nameResolver;
    private final EntityDescriptor from;
    private final EntityDescriptor to;
    private final AttributeDescriptor attribute;

    JoinEntityGenerator(ProcessingEnvironment processingEnvironment, EntityNameResolver nameResolver, EntityDescriptor from, EntityDescriptor to, AttributeDescriptor attribute) {
        this.processingEnvironment = processingEnvironment;
        this.nameResolver = nameResolver;
        this.from = from;
        this.to = to;
        this.attribute = attribute;
    }

    @Override
    public void generate() throws IOException {
        if (!this.attribute.associativeEntity().isPresent()) {
            throw new IllegalStateException();
        }
        AssociativeEntityDescriptor associativeDescriptor = this.attribute.associativeEntity().get();
        String name = associativeDescriptor.name();
        if (Names.isEmpty(name)) {
            name = this.from.tableName() + "_" + this.to.tableName();
        }
        ClassName joinEntityName = this.nameResolver.generatedJoinEntityName(associativeDescriptor, this.from, this.to);
        String className = "Abstract" + joinEntityName.simpleName();
        TypeSpec.Builder junctionType = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addSuperinterface(Serializable.class).addAnnotation(AnnotationSpec.builder(Entity.class).addMember("model", "$S", new Object[]{this.from.modelName()}).build()).addAnnotation(AnnotationSpec.builder(Table.class).addMember("name", "$S", new Object[]{name}).build());
        CodeGeneration.addGeneratedAnnotation(this.processingEnvironment, junctionType);
        Set<AssociativeReference> references = associativeDescriptor.columns();
        EntityDescriptor[] types = new EntityDescriptor[]{this.from, this.to};
        if (references.isEmpty()) {
            for (EntityDescriptor type : types) {
                AssociativeReference reference = new AssociativeReference(type.tableName() + "Id", ReferentialAction.CASCADE, type.element());
                references.add(reference);
            }
        }
        int typeIndex = 0;
        for (AssociativeReference reference : references) {
            AnnotationSpec.Builder key = AnnotationSpec.builder(ForeignKey.class).addMember("action", "$T.$L", new Object[]{ClassName.get(ReferentialAction.class), reference.referentialAction().toString()});
            TypeElement referenceElement = reference.referencedType();
            if (referenceElement == null && typeIndex < types.length) {
                referenceElement = types[typeIndex++].element();
            }
            if (referenceElement != null) {
                key.addMember("references", "$L.class", new Object[]{this.nameResolver.generatedTypeNameOf(referenceElement).get()});
            }
            AnnotationSpec.Builder id = AnnotationSpec.builder(Key.class);
            FieldSpec.Builder field = FieldSpec.builder(Integer.class, (String)reference.name(), (Modifier[])new Modifier[]{Modifier.PROTECTED}).addAnnotation(key.build()).addAnnotation(id.build());
            junctionType.addField(field.build());
        }
        CodeGeneration.writeType(this.processingEnvironment, joinEntityName.packageName(), junctionType.build());
    }
}

