/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import com.squareup.javapoet.TypeName;

class GeneratedProperty {
    private final String attributeName;
    private final String methodSuffix;
    private final TypeName targetName;
    private final TypeName propertyTypeName;
    private final boolean isSetter;
    private final boolean isNullable;
    private final boolean isReadOnly;
    private final boolean isWriteOnly;

    private GeneratedProperty(String attributeName, TypeName targetName, TypeName propertyTypeName, String methodSuffix, boolean isSetter, boolean isNullable, boolean isReadOnly, boolean isWriteOnly) {
        this.attributeName = attributeName;
        this.targetName = targetName;
        this.propertyTypeName = propertyTypeName;
        this.methodSuffix = methodSuffix;
        this.isSetter = isSetter;
        this.isNullable = isNullable;
        this.isReadOnly = isReadOnly;
        this.isWriteOnly = isWriteOnly;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public String methodSuffix() {
        return this.methodSuffix;
    }

    public boolean isSetter() {
        return this.isSetter;
    }

    public TypeName targetName() {
        return this.targetName;
    }

    public TypeName propertyTypeName() {
        return this.propertyTypeName;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    static class Builder {
        private String attributeName;
        private String methodSuffix = "";
        private TypeName targetName;
        private TypeName propertyTypeName;
        private boolean isSetter;
        private boolean isNullable;
        private boolean isReadOnly;
        private boolean isWriteOnly;

        Builder(String attributeName, TypeName targetName, TypeName propertyTypeName) {
            this.attributeName = attributeName;
            this.targetName = targetName;
            this.propertyTypeName = propertyTypeName;
        }

        Builder setSetter(boolean setter) {
            this.isSetter = setter;
            return this;
        }

        Builder setSuffix(String suffix) {
            this.methodSuffix = suffix;
            return this;
        }

        Builder setNullable(boolean nullable) {
            this.isNullable = nullable;
            return this;
        }

        Builder setReadOnly(boolean readOnly) {
            this.isReadOnly = readOnly;
            return this;
        }

        Builder setWriteOnly(boolean writeOnly) {
            this.isWriteOnly = writeOnly;
            return this;
        }

        GeneratedProperty build() {
            return new GeneratedProperty(this.attributeName, this.targetName, this.propertyTypeName, this.methodSuffix, this.isSetter, this.isNullable, this.isReadOnly, this.isWriteOnly);
        }
    }
}

