/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.Entity;
import io.requery.Factory;
import io.requery.PropertyNameStyle;
import io.requery.ReadOnly;
import io.requery.Table;
import io.requery.Transient;
import io.requery.processor.AttributeDescriptor;
import io.requery.processor.AttributeMember;
import io.requery.processor.BaseProcessableElement;
import io.requery.processor.ElementValidator;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.ListenerAnnotations;
import io.requery.processor.ListenerDescriptor;
import io.requery.processor.ListenerMethod;
import io.requery.processor.Mirrors;
import io.requery.processor.Names;
import io.requery.processor.ProcessableElement;
import io.requery.processor.QualifiedName;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.persistence.Cacheable;
import javax.tools.Diagnostic;

class EntityType
extends BaseProcessableElement<TypeElement>
implements EntityDescriptor {
    private final ProcessingEnvironment processingEnvironment;
    private final Map<Element, AttributeDescriptor> attributes;
    private final Map<Element, ListenerMethod> listeners;

    EntityType(ProcessingEnvironment processingEnvironment, TypeElement typeElement) {
        super(typeElement);
        this.processingEnvironment = processingEnvironment;
        this.attributes = new LinkedHashMap<Element, AttributeDescriptor>();
        this.listeners = new LinkedHashMap<Element, ListenerMethod>();
    }

    @Override
    public Set<ElementValidator> process(ProcessingEnvironment processingEnvironment) {
        TypeElement typeElement = (TypeElement)this.element();
        if (typeElement.getKind().isInterface() || this.isImmutable()) {
            ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().filter(this::isMethodProcessable).forEach(this::computeAttribute);
        } else {
            ElementFilter.fieldsIn(typeElement.getEnclosedElements()).stream().filter(element -> !element.getModifiers().contains((Object)Modifier.PRIVATE) && !element.getModifiers().contains((Object)Modifier.STATIC) && (!element.getModifiers().contains((Object)Modifier.FINAL) || this.isImmutable())).forEach(this::computeAttribute);
        }
        LinkedHashSet<ListenerMethod> elements = new LinkedHashSet<ListenerMethod>();
        this.attributes().values().forEach(attribute -> elements.add((ListenerMethod)((ProcessableElement)((Object)attribute))));
        elements.addAll(this.listeners.values());
        LinkedHashSet<ElementValidator> validations = new LinkedHashSet<ElementValidator>();
        elements.forEach(element -> validations.addAll(element.process(processingEnvironment)));
        ElementValidator validator = new ElementValidator((Element)this.element(), processingEnvironment);
        Entity entity = this.annotationOf(Entity.class).orElse(null);
        if (entity != null && !Names.isEmpty(entity.name()) && !SourceVersion.isIdentifier(entity.name())) {
            validator.error("Invalid class identifier " + entity.name(), Entity.class);
        }
        if (((TypeElement)this.element()).getNestingKind() == NestingKind.ANONYMOUS) {
            validator.error("Entity annotation cannot be applied to anonymous class");
        }
        if (((TypeElement)this.element()).getKind().isClass() && ((TypeElement)this.element()).getModifiers().contains((Object)Modifier.FINAL)) {
            validator.error("Entity annotation cannot be applied to final class");
        }
        if (((TypeElement)this.element()).getKind() == ElementKind.ENUM) {
            validator.error("Entity annotation cannot be applied to an enum class");
        }
        if (this.attributes.values().isEmpty()) {
            validator.error("Entity contains no attributes");
        }
        if (!this.isReadOnly() && this.attributes.values().size() == 1 && this.attributes.values().iterator().next().isGenerated()) {
            validator.warning("Entity contains only a single generated attribute may fail to persist");
        }
        validations.add(validator);
        return validations;
    }

    private boolean isMethodProcessable(ExecutableElement element) {
        TypeMirror type = element.getReturnType();
        return type.getKind() != TypeKind.VOID && element.getParameters().isEmpty() && !type.equals(((TypeElement)this.element()).asType()) && !type.equals(this.builderType().isPresent() ? this.builderType().get().asType() : null) && !Mirrors.findAnnotationMirror((Element)element, Transient.class).isPresent() && !element.getModifiers().contains((Object)Modifier.STATIC);
    }

    void addAnnotationElement(TypeElement annotationElement, Element annotatedElement) {
        Class<Annotation> type;
        String qualifiedName = annotationElement.getQualifiedName().toString();
        try {
            type = Class.forName(qualifiedName).asSubclass(Annotation.class);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        switch (annotatedElement.getKind()) {
            case CLASS: 
            case INTERFACE: {
                this.annotations().put(type, annotatedElement.getAnnotation(type));
                break;
            }
            case FIELD: {
                if (annotatedElement.getModifiers().contains((Object)Modifier.STATIC) || annotatedElement.getModifiers().contains((Object)Modifier.FINAL)) {
                    this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, annotationElement.getSimpleName() + " not applicable to static or final member", annotatedElement);
                    break;
                }
                VariableElement element = (VariableElement)annotatedElement;
                Optional<AttributeMember> attribute = this.computeAttribute(element);
                Annotation annotation = annotatedElement.getAnnotation(type);
                attribute.ifPresent(a -> a.annotations().put(type, annotation));
                break;
            }
            case METHOD: {
                ExecutableElement element = (ExecutableElement)annotatedElement;
                Annotation annotation = annotatedElement.getAnnotation(type);
                if (ListenerAnnotations.all().anyMatch(a -> a.equals(type))) {
                    ListenerMethod listener = this.listeners.computeIfAbsent(element, key -> new ListenerMethod(element));
                    listener.annotations().put(type, annotation);
                    break;
                }
                if (!this.isMethodProcessable(element)) break;
                Optional<AttributeMember> attribute = this.computeAttribute(element);
                attribute.ifPresent(a -> a.annotations().put(type, annotation));
            }
        }
    }

    private Optional<AttributeMember> computeAttribute(Element element) {
        ExecutableElement executableElement;
        TypeMirror returnType;
        if (element.getKind() == ElementKind.METHOD && (returnType = (executableElement = (ExecutableElement)element).getReturnType()).equals(((TypeElement)this.element()).asType())) {
            return Optional.empty();
        }
        return Optional.of((AttributeMember)this.attributes.computeIfAbsent(element, key -> new AttributeMember(element, this)));
    }

    boolean generatesAdditionalTypes() {
        return this.attributes.values().stream().anyMatch(member -> member.associativeEntity().isPresent());
    }

    @Override
    public Map<Element, ? extends AttributeDescriptor> attributes() {
        return this.attributes;
    }

    @Override
    public Map<Element, ? extends ListenerDescriptor> listeners() {
        return this.listeners;
    }

    @Override
    public String modelName() {
        Optional<? extends AnnotationMirror> mirror = Mirrors.findAnnotationMirror(this.element(), Entity.class);
        if (mirror.isPresent()) {
            return Mirrors.findAnnotationValue(mirror.get(), "model").map(value -> value.getValue().toString()).filter(name -> !Names.isEmpty(name)).orElse("default");
        }
        if (Mirrors.findAnnotationMirror(this.element(), javax.persistence.Entity.class).isPresent()) {
            Elements elements = this.processingEnvironment.getElementUtils();
            Name packageName = elements.getPackageOf((Element)this.element()).getQualifiedName();
            String[] parts = packageName.toString().split("\\.");
            return parts[parts.length - 1];
        }
        throw new IllegalStateException();
    }

    @Override
    public QualifiedName typeName() {
        String entityName = this.annotationOf(Entity.class).map(Entity::name).orElse(this.annotationOf(javax.persistence.Entity.class).map(javax.persistence.Entity::name).orElse(null));
        Elements elements = this.processingEnvironment.getElementUtils();
        PackageElement packageElement = elements.getPackageOf((Element)this.element());
        String packageName = packageElement.getQualifiedName().toString();
        if (!Names.isEmpty(entityName)) {
            return new QualifiedName(packageName, entityName);
        }
        String typeName = ((TypeElement)this.element()).getSimpleName().toString();
        if (((TypeElement)this.element()).getKind().isInterface()) {
            entityName = typeName.startsWith("I") && Character.isUpperCase(typeName.charAt(1)) ? typeName.substring(1) : typeName + "Entity";
        } else {
            entityName = Names.removeClassPrefixes(typeName);
            if (entityName.equals(typeName)) {
                entityName = typeName + (this.isImmutable() ? "Type" : "Entity");
            }
        }
        return new QualifiedName(packageName, entityName);
    }

    @Override
    public PropertyNameStyle propertyNameStyle() {
        return this.annotationOf(Entity.class).map(Entity::propertyNameStyle).orElse(PropertyNameStyle.BEAN);
    }

    @Override
    public String tableName() {
        return this.annotationOf(Table.class).map(Table::name).orElse(this.annotationOf(javax.persistence.Table.class).map(javax.persistence.Table::name).orElse(((TypeElement)this.element()).getKind().isInterface() || this.isImmutable() ? ((TypeElement)this.element()).getSimpleName().toString() : Names.removeClassPrefixes(((TypeElement)this.element()).getSimpleName())));
    }

    @Override
    public String[] tableAttributes() {
        return this.annotationOf(Table.class).map(Table::createAttributes).orElse(new String[0]);
    }

    @Override
    public boolean isCacheable() {
        return this.annotationOf(Entity.class).map(Entity::cacheable).orElse(this.annotationOf(Cacheable.class).map(Cacheable::value).orElse(true));
    }

    @Override
    public boolean isReadOnly() {
        return this.annotationOf(ReadOnly.class).isPresent();
    }

    @Override
    public boolean isStateless() {
        return this.isImmutable() || this.annotationOf(Entity.class).map(Entity::stateless).orElse(false) != false;
    }

    @Override
    public boolean isImmutable() {
        return Stream.of("com.google.auto.value.AutoValue", "auto.parcel.AutoParcel", "org.immutables.value.Value.Immutable").filter(type -> Mirrors.findAnnotationMirror(this.element(), type).isPresent()).findAny().isPresent() || this.annotationOf(Entity.class).map(Entity::immutable).orElse(false) != false;
    }

    @Override
    public Optional<TypeElement> builderType() {
        block3: {
            Optional<Entity> entityAnnotation = this.annotationOf(Entity.class);
            if (entityAnnotation.isPresent()) {
                Entity entity = entityAnnotation.get();
                try {
                    entity.builder();
                }
                catch (MirroredTypeException typeException) {
                    TypeMirror mirror = typeException.getTypeMirror();
                    Elements elements = this.processingEnvironment.getElementUtils();
                    TypeElement element2 = elements.getTypeElement(mirror.toString());
                    if (element2 == null) break block3;
                    return Optional.of(element2);
                }
            }
        }
        return ElementFilter.typesIn(((TypeElement)this.element()).getEnclosedElements()).stream().filter(element -> element.getSimpleName().toString().equals("Builder")).findFirst();
    }

    @Override
    public Optional<ExecutableElement> builderFactoryMethod() {
        return ElementFilter.methodsIn(((TypeElement)this.element()).getEnclosedElements()).stream().filter(element -> element.getModifiers().contains((Object)Modifier.STATIC)).filter(element -> element.getSimpleName().toString().equals("builder")).findFirst();
    }

    @Override
    public Optional<ExecutableElement> factoryMethod() {
        return ElementFilter.methodsIn(((TypeElement)this.element()).getEnclosedElements()).stream().filter(element -> element.getModifiers().contains((Object)Modifier.STATIC)).filter(element -> element.getSimpleName().toString().equalsIgnoreCase("create")).filter(element -> element.getReturnType().equals(((TypeElement)this.element()).asType())).findAny();
    }

    @Override
    public String classFactoryName() {
        return Mirrors.findAnnotationMirror(this.element(), Factory.class).flatMap(Mirrors::findAnnotationValue).map(value -> value.getValue().toString()).orElse(null);
    }
}

