/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import io.requery.processor.AssociativeEntityDescriptor;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.EntityGraph;
import io.requery.processor.Names;
import java.util.Optional;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

class EntityNameResolver {
    private final EntityGraph graph;

    EntityNameResolver(EntityGraph graph) {
        this.graph = graph;
    }

    TypeName typeNameOf(EntityDescriptor type) {
        return ClassName.bestGuess((String)type.typeName().toString());
    }

    TypeName tryGeneratedTypeName(TypeMirror typeMirror) {
        return this.generatedTypeNameOf(typeMirror).orElseGet(() -> TypeName.get((TypeMirror)typeMirror));
    }

    Optional<TypeName> generatedTypeNameOf(TypeMirror typeMirror) {
        return this.graph.entities().stream().filter(entity -> entity.typeName().className().equals(typeMirror.toString())).map(this::typeNameOf).findFirst();
    }

    Optional<TypeName> generatedTypeNameOf(TypeElement typeElement) {
        return this.graph.entities().stream().filter(entity -> entity.element().getQualifiedName().equals(typeElement.getQualifiedName())).map(this::typeNameOf).findFirst();
    }

    ClassName generatedJoinEntityName(AssociativeEntityDescriptor descriptor, EntityDescriptor a, EntityDescriptor b) {
        String className = Names.isEmpty(descriptor.name()) ? a.typeName().className() + "_" + b.typeName().className() : Names.upperCaseFirst(descriptor.name());
        return ClassName.get((String)a.typeName().packageName(), (String)className, (String[])new String[0]);
    }
}

