/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.requery.CascadeAction;
import io.requery.Persistable;
import io.requery.PropertyNameStyle;
import io.requery.ReferentialAction;
import io.requery.meta.Attribute;
import io.requery.meta.Cardinality;
import io.requery.meta.QueryAttribute;
import io.requery.meta.Type;
import io.requery.meta.TypeBuilder;
import io.requery.processor.AndroidObservableExtension;
import io.requery.processor.AndroidParcelableExtension;
import io.requery.processor.AttributeDescriptor;
import io.requery.processor.CodeGeneration;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.EntityGraph;
import io.requery.processor.EntityNameResolver;
import io.requery.processor.GeneratedProperty;
import io.requery.processor.JoinEntityGenerator;
import io.requery.processor.ListenerDescriptor;
import io.requery.processor.Mirrors;
import io.requery.processor.Names;
import io.requery.processor.PropertyGenerationExtension;
import io.requery.processor.SourceGenerator;
import io.requery.processor.TypeGenerationExtension;
import io.requery.proxy.BooleanProperty;
import io.requery.proxy.ByteProperty;
import io.requery.proxy.DoubleProperty;
import io.requery.proxy.EntityProxy;
import io.requery.proxy.FloatProperty;
import io.requery.proxy.IntProperty;
import io.requery.proxy.LongProperty;
import io.requery.proxy.PreInsertListener;
import io.requery.proxy.Property;
import io.requery.proxy.PropertyState;
import io.requery.proxy.ShortProperty;
import io.requery.util.function.Function;
import io.requery.util.function.Supplier;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class EntityGenerator
implements SourceGenerator {
    static final String PROXY_NAME = "$proxy";
    static final String TYPE_NAME = "$TYPE";
    private final ProcessingEnvironment processingEnvironment;
    private final Elements elements;
    private final Types types;
    private final EntityDescriptor entity;
    private final HashSet<String> fieldNames;
    private final TypeElement typeElement;
    private final ClassName typeName;
    private final EntityGraph graph;
    private final EntityNameResolver nameResolver;
    private final Set<TypeGenerationExtension> typeExtensions;
    private final Set<PropertyGenerationExtension> memberExtensions;

    EntityGenerator(ProcessingEnvironment processingEnvironment, EntityGraph graph, EntityDescriptor entity) {
        this.entity = entity;
        this.processingEnvironment = processingEnvironment;
        this.elements = processingEnvironment.getElementUtils();
        this.types = processingEnvironment.getTypeUtils();
        this.graph = graph;
        this.nameResolver = new EntityNameResolver(graph);
        this.fieldNames = new HashSet();
        this.typeElement = entity.element();
        this.typeName = (ClassName)this.nameResolver.typeNameOf(entity);
        this.typeExtensions = new HashSet<TypeGenerationExtension>();
        this.memberExtensions = new HashSet<PropertyGenerationExtension>();
        this.typeExtensions.add(new AndroidParcelableExtension(this.types));
        AndroidObservableExtension observable = new AndroidObservableExtension(entity, processingEnvironment);
        this.typeExtensions.add(observable);
        this.memberExtensions.add(observable);
    }

    @Override
    public void generate() throws IOException {
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)this.typeName.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        typeBuilder.addOriginatingElement((Element)this.typeElement);
        if (this.typeElement.getKind().isInterface()) {
            typeBuilder.addSuperinterface((TypeName)ClassName.get((TypeElement)this.typeElement));
            typeBuilder.addSuperinterface((TypeName)ClassName.get(Persistable.class));
        } else if (!this.entity.isImmutable()) {
            typeBuilder.superclass((TypeName)ClassName.get((TypeElement)this.typeElement));
            typeBuilder.addSuperinterface((TypeName)ClassName.get(Persistable.class));
        }
        CodeGeneration.addGeneratedAnnotation(this.processingEnvironment, typeBuilder);
        this.generateStaticMetadata(typeBuilder);
        if (!this.entity.isImmutable()) {
            this.generateConstructors(typeBuilder);
            this.generateMembers(typeBuilder);
            this.generateProxyMethods(typeBuilder);
            this.generateEquals(typeBuilder);
            this.generateHashCode(typeBuilder);
            this.generateToString(typeBuilder);
        } else {
            typeBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
            this.generateMembers(typeBuilder);
            this.generateImmutableTypeBuildMethod(typeBuilder);
        }
        for (TypeGenerationExtension typePart : this.typeExtensions) {
            typePart.generate(this.entity, typeBuilder);
        }
        CodeGeneration.writeType(this.processingEnvironment, this.typeName.packageName(), typeBuilder.build());
    }

    private void generateMembers(TypeSpec.Builder typeBuilder) {
        boolean generateMembers;
        if (!this.entity.isStateless()) {
            for (Map.Entry<Element, ? extends AttributeDescriptor> entry : this.entity.attributes().entrySet()) {
                AttributeDescriptor attribute = entry.getValue();
                ClassName stateType = ClassName.get(PropertyState.class);
                FieldSpec field = FieldSpec.builder((TypeName)stateType, (String)this.propertyStateFieldName(attribute), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
                typeBuilder.addField(field);
            }
        }
        boolean bl = generateMembers = this.typeElement.getKind().isInterface() || this.entity.isImmutable() && !this.entity.builderType().isPresent();
        if (generateMembers) {
            for (Map.Entry<Element, ? extends AttributeDescriptor> entry : this.entity.attributes().entrySet()) {
                ParameterizedTypeName fieldTypeName;
                Element element = entry.getKey();
                AttributeDescriptor attribute = entry.getValue();
                if (element.getKind() != ElementKind.METHOD) continue;
                ExecutableElement methodElement = (ExecutableElement)element;
                TypeMirror typeMirror = methodElement.getReturnType();
                if (attribute.isIterable()) {
                    fieldTypeName = this.parameterizedCollectionName(typeMirror);
                } else if (attribute.isOptional()) {
                    typeMirror = EntityGenerator.tryFirstTypeArgument(attribute.typeMirror());
                    fieldTypeName = TypeName.get((TypeMirror)typeMirror);
                } else {
                    fieldTypeName = this.nameResolver.tryGeneratedTypeName(typeMirror);
                }
                FieldSpec field = FieldSpec.builder((TypeName)fieldTypeName, (String)attribute.fieldName(), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
                typeBuilder.addField(field);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void generateConstructors(TypeSpec.Builder typeBuilder) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(this.typeElement.getEnclosedElements())) {
            List<? extends VariableElement> parameters = constructor.getParameters();
            if (parameters.isEmpty()) continue;
            MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder();
            constructorBuilder.addModifiers(constructor.getModifiers());
            ArrayList<String> parameterNames = new ArrayList<String>();
            for (VariableElement variableElement : parameters) {
                Modifier[] modifiers = variableElement.getModifiers().toArray(new Modifier[variableElement.getModifiers().size()]);
                String parameterName = variableElement.getSimpleName().toString();
                parameterNames.add(parameterName);
                ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)variableElement.asType()), (String)parameterName, (Modifier[])modifiers);
                constructorBuilder.addParameter(parameterBuilder.build());
            }
            StringBuilder superParameters = new StringBuilder();
            boolean bl = false;
            for (String parameterName : parameterNames) {
                void var8_8;
                if (var8_8 > 0) {
                    superParameters.append(",");
                }
                superParameters.append(parameterName);
                ++var8_8;
            }
            constructorBuilder.addCode(CodeBlock.builder().addStatement("super(" + superParameters.toString() + ")", new Object[0]).build());
            typeBuilder.addMethod(constructorBuilder.build());
        }
    }

    private void generateProxyMethods(TypeSpec.Builder typeBuilder) {
        ParameterizedTypeName proxyName = EntityGenerator.parameterizedTypeName(EntityProxy.class, new TypeName[]{this.typeName});
        FieldSpec.Builder proxyField = FieldSpec.builder((TypeName)proxyName, (String)PROXY_NAME, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.TRANSIENT});
        proxyField.initializer("new $T(this, $L)", new Object[]{proxyName, TYPE_NAME});
        typeBuilder.addField(proxyField.build());
        for (Map.Entry<Element, ? extends AttributeDescriptor> entry : this.entity.attributes().entrySet()) {
            AttributeDescriptor attribute = entry.getValue();
            boolean isTransient = attribute.isTransient();
            TypeMirror typeMirror = attribute.typeMirror();
            Object unboxedTypeName = attribute.isIterable() ? this.parameterizedCollectionName(typeMirror) : (attribute.isOptional() ? TypeName.get((TypeMirror)EntityGenerator.tryFirstTypeArgument(attribute.typeMirror())) : this.nameResolver.tryGeneratedTypeName(typeMirror));
            String attributeName = attribute.fieldName();
            String getterName = entry.getValue().getterName();
            String fieldName = Names.upperCaseUnderscore(Names.removeMemberPrefixes(attributeName));
            MethodSpec.Builder getter = MethodSpec.methodBuilder((String)getterName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)(attribute.isOptional() ? TypeName.get((TypeMirror)attribute.typeMirror()) : unboxedTypeName));
            if (Mirrors.overridesMethod(this.types, this.typeElement, getterName)) {
                getter.addAnnotation(Override.class);
            }
            for (PropertyGenerationExtension snippet : this.memberExtensions) {
                snippet.addToGetter(attribute, getter);
            }
            if (isTransient) {
                getter.addStatement("return this.$L", new Object[]{attributeName});
            } else if (attribute.isOptional()) {
                getter.addStatement("return $T.ofNullable($L.get($L))", new Object[]{Optional.class, PROXY_NAME, fieldName});
            } else {
                getter.addStatement("return $L.get($L)", new Object[]{PROXY_NAME, fieldName});
            }
            typeBuilder.addMethod(getter.build());
            String setterName = entry.getValue().setterName();
            boolean readOnly = this.entity.isReadOnly() || attribute.isReadOnly();
            if (readOnly) continue;
            String argumentName = Names.lowerCaseFirst(Names.removeMemberPrefixes(attributeName));
            MethodSpec.Builder setter = MethodSpec.methodBuilder((String)setterName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)unboxedTypeName, argumentName, new Modifier[0]);
            if (isTransient) {
                setter.addStatement("this.$L = $L", new Object[]{attributeName, argumentName});
            } else {
                setter.addStatement("$L.set($L, $L)", new Object[]{PROXY_NAME, fieldName, argumentName});
            }
            for (PropertyGenerationExtension snippet : this.memberExtensions) {
                snippet.addToSetter(attribute, setter);
            }
            PropertyNameStyle style = this.entity.propertyNameStyle();
            if (style == PropertyNameStyle.FLUENT || style == PropertyNameStyle.FLUENT_BEAN) {
                setter.addStatement("return this", new Object[0]);
                setter.returns((TypeName)this.typeName);
            }
            typeBuilder.addMethod(setter.build());
        }
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.generateListeners(constructor);
        typeBuilder.addMethod(constructor.build());
    }

    private void generateEquals(TypeSpec.Builder typeBuilder) {
        boolean overridesEquals = Mirrors.overridesMethod(this.types, this.typeElement, "equals");
        if (!overridesEquals) {
            MethodSpec.Builder equals = CodeGeneration.overridePublicMethod("equals").addParameter((TypeName)TypeName.OBJECT, "obj", new Modifier[0]).returns(TypeName.BOOLEAN).addStatement("return obj instanceof $T && (($T)obj).$L.equals(this.$L)", new Object[]{this.typeName, this.typeName, PROXY_NAME, PROXY_NAME});
            typeBuilder.addMethod(equals.build());
        }
    }

    private void generateHashCode(TypeSpec.Builder typeBuilder) {
        if (!Mirrors.overridesMethod(this.types, this.typeElement, "hashCode")) {
            MethodSpec.Builder hashCode = CodeGeneration.overridePublicMethod("hashCode").returns(TypeName.INT).addStatement("return $L.hashCode()", new Object[]{PROXY_NAME});
            typeBuilder.addMethod(hashCode.build());
        }
    }

    private void generateToString(TypeSpec.Builder typeBuilder) {
        if (!Mirrors.overridesMethod(this.types, this.typeElement, "toString")) {
            MethodSpec.Builder equals = CodeGeneration.overridePublicMethod("toString").returns(String.class).addStatement("return $L.toString()", new Object[]{PROXY_NAME});
            typeBuilder.addMethod(equals.build());
        }
    }

    private void generateListeners(MethodSpec.Builder constructor) {
        for (Map.Entry<Element, ? extends ListenerDescriptor> entry : this.entity.listeners().entrySet()) {
            for (Annotation annotation : entry.getValue().listenerAnnotations()) {
                String annotationName = annotation.annotationType().getSimpleName();
                annotationName = annotationName.replace("Persist", "Insert").replace("Remove", "Delete");
                String methodName = Names.lowerCaseFirst(annotationName);
                TypeElement listener = this.elements.getTypeElement(PreInsertListener.class.getCanonicalName());
                PackageElement packageElement = this.elements.getPackageOf(listener);
                String packageName = packageElement.getQualifiedName().toString();
                ClassName listenerName = ClassName.get((String)packageName, (String)(annotationName + "Listener"), (String[])new String[0]);
                ParameterizedTypeName getterType = ParameterizedTypeName.get((ClassName)listenerName, (TypeName[])new TypeName[]{this.typeName});
                TypeSpec.Builder listenerBuilder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)getterType).addMethod(CodeGeneration.overridePublicMethod(methodName).addParameter((TypeName)this.typeName, "entity", new Modifier[0]).addStatement("$L()", new Object[]{entry.getKey().getSimpleName()}).build());
                constructor.addStatement("$L.modifyListeners().add$L($L)", new Object[]{PROXY_NAME, annotationName + "Listener", listenerBuilder.build()});
            }
        }
    }

    private void generateType(TypeSpec.Builder typeSpecBuilder) {
        ClassName targetName = this.entity.isImmutable() ? ClassName.get((TypeElement)this.entity.element()) : this.typeName;
        ClassName schemaName = ClassName.get(TypeBuilder.class);
        ParameterizedTypeName type = EntityGenerator.parameterizedTypeName(Type.class, new TypeName[]{targetName});
        FieldSpec.Builder schemaFieldBuilder = FieldSpec.builder((TypeName)type, (String)TYPE_NAME, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        CodeBlock.Builder typeBuilder = CodeBlock.builder().add("new $T<$T>($T.class, $S)\n", new Object[]{schemaName, targetName, targetName, this.entity.tableName()});
        typeBuilder.add(".setBaseType($T.class)\n", new Object[]{ClassName.get((TypeElement)this.typeElement)}).add(".setCacheable($L)\n", new Object[]{this.entity.isCacheable()}).add(".setImmutable($L)\n", new Object[]{this.entity.isImmutable()}).add(".setReadOnly($L)\n", new Object[]{this.entity.isReadOnly()}).add(".setStateless($L)\n", new Object[]{this.entity.isStateless()});
        String factoryName = this.entity.classFactoryName();
        if (!Names.isEmpty(factoryName)) {
            typeBuilder.add(".setFactory(new $L())\n", new Object[]{ClassName.bestGuess((String)factoryName)});
        } else if (this.entity.isImmutable()) {
            ClassName builderName = this.entity.builderType().isPresent() ? TypeName.get((TypeMirror)this.entity.builderType().get().asType()) : this.typeName;
            TypeSpec.Builder typeFactory = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)EntityGenerator.parameterizedTypeName(Supplier.class, new TypeName[]{builderName}));
            MethodSpec buildMethod = this.entity.builderFactoryMethod().isPresent() ? CodeGeneration.overridePublicMethod("get").addStatement("return $T.$L()", new Object[]{targetName, this.entity.builderFactoryMethod().get().getSimpleName().toString()}).returns((TypeName)builderName).build() : CodeGeneration.overridePublicMethod("get").addStatement("return new $T()", new Object[]{builderName}).returns((TypeName)builderName).build();
            typeFactory.addMethod(buildMethod);
            typeBuilder.add(".setBuilderFactory($L)\n", new Object[]{typeFactory.build()});
            TypeSpec.Builder buildFunction = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)EntityGenerator.parameterizedTypeName(Function.class, new TypeName[]{builderName, targetName})).addMethod(CodeGeneration.overridePublicMethod("apply").addParameter((TypeName)builderName, "value", new Modifier[0]).addStatement("return value.build()", new Object[0]).returns((TypeName)targetName).build());
            typeBuilder.add(".setBuilderFunction($L)\n", new Object[]{buildFunction.build()});
        } else {
            TypeSpec.Builder typeFactory = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)EntityGenerator.parameterizedTypeName(Supplier.class, new TypeName[]{targetName})).addMethod(CodeGeneration.overridePublicMethod("get").addStatement("return new $T()", new Object[]{targetName}).returns((TypeName)targetName).build());
            typeBuilder.add(".setFactory($L)\n", new Object[]{typeFactory.build()});
        }
        ParameterizedTypeName proxyType = EntityGenerator.parameterizedTypeName(EntityProxy.class, new TypeName[]{targetName});
        TypeSpec.Builder proxyProvider = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)EntityGenerator.parameterizedTypeName(Function.class, new TypeName[]{targetName, proxyType}));
        MethodSpec.Builder proxyFunction = CodeGeneration.overridePublicMethod("apply").addParameter((TypeName)targetName, "entity", new Modifier[0]).returns((TypeName)proxyType);
        if (this.entity.isImmutable()) {
            proxyFunction.addStatement("return new $T(entity, $L)", new Object[]{proxyType, TYPE_NAME});
        } else {
            proxyFunction.addStatement("return entity.$L", new Object[]{PROXY_NAME});
        }
        proxyProvider.addMethod(proxyFunction.build());
        typeBuilder.add(".setProxyProvider($L)\n", new Object[]{proxyProvider.build()});
        if (this.entity.tableAttributes() != null && this.entity.tableAttributes().length > 0) {
            StringJoiner joiner = new StringJoiner(",", "new String[] {", "}");
            for (String attribute : this.entity.tableAttributes()) {
                joiner.add("\"" + attribute + "\"");
            }
            typeBuilder.add(".setTableCreateAttributes($L)\n", new Object[]{joiner.toString()});
        }
        this.fieldNames.forEach(name -> typeBuilder.add(".addAttribute($L)\n", new Object[]{name}));
        typeBuilder.add(".build()", new Object[0]);
        schemaFieldBuilder.initializer("$L", new Object[]{typeBuilder.build()});
        typeSpecBuilder.addField(schemaFieldBuilder.build());
    }

    private void generateImmutableTypeBuildMethod(TypeSpec.Builder builder) {
        if (this.entity.isImmutable() && !this.entity.builderType().isPresent() && this.entity.factoryMethod().isPresent()) {
            ExecutableElement createMethod = this.entity.factoryMethod().get();
            LinkedHashMap<Element, ? extends AttributeDescriptor> attributes = new LinkedHashMap<Element, AttributeDescriptor>();
            attributes.putAll(this.entity.attributes());
            List<? extends VariableElement> parameters = createMethod.getParameters();
            ArrayList<String> argumentNames = new ArrayList<String>();
            for (VariableElement variableElement : parameters) {
                Element matched = null;
                for (Map.Entry entry : attributes.entrySet()) {
                    AttributeDescriptor attribute = (AttributeDescriptor)entry.getValue();
                    String fieldName = attribute.fieldName();
                    if (!fieldName.equalsIgnoreCase(variableElement.getSimpleName().toString())) continue;
                    argumentNames.add(fieldName);
                    matched = (Element)entry.getKey();
                }
                if (matched == null) continue;
                attributes.remove(matched);
            }
            StringJoiner joiner = new StringJoiner(",");
            argumentNames.forEach(name -> joiner.add("$L"));
            Object[] objectArray = new Object[2 + argumentNames.size()];
            objectArray[0] = ClassName.get((TypeElement)this.entity.element());
            objectArray[1] = createMethod.getSimpleName();
            System.arraycopy(argumentNames.toArray(), 0, objectArray, 2, argumentNames.size());
            builder.addMethod(MethodSpec.methodBuilder((String)"build").returns((TypeName)ClassName.get((TypeElement)this.entity.element())).addStatement("return $T.$L(" + joiner.toString() + ")", objectArray).build());
        }
    }

    private void addPropertyMethods(TypeSpec.Builder builder, GeneratedProperty property) {
        String suffix = property.methodSuffix();
        TypeName targetName = property.targetName();
        TypeName propertyTypeName = property.propertyTypeName();
        String propertyName = property.attributeName();
        MethodSpec.Builder getMethod = CodeGeneration.overridePublicMethod("get" + suffix).addParameter(targetName, "entity", new Modifier[0]).returns(propertyTypeName);
        if (property.isWriteOnly()) {
            getMethod.addStatement("throw new UnsupportedOperationException()", new Object[0]);
        } else {
            getMethod.addStatement("return entity.$L", new Object[]{propertyName});
        }
        MethodSpec.Builder setMethod = CodeGeneration.overridePublicMethod("set" + suffix).addParameter(targetName, "entity", new Modifier[0]).addParameter(propertyTypeName, "value", new Modifier[0]);
        if (property.isReadOnly()) {
            setMethod.addStatement("throw new UnsupportedOperationException()", new Object[0]);
        } else if (property.isNullable()) {
            CodeBlock setterBlock = CodeBlock.builder().beginControlFlow("if(value != null)", new Object[0]).addStatement("entity.$L = value", new Object[]{propertyName}).endControlFlow().build();
            setMethod.addCode(setterBlock);
        } else if (property.isSetter()) {
            setMethod.addStatement("entity.$L(value)", new Object[]{propertyName});
        } else {
            setMethod.addStatement("entity.$L = value", new Object[]{propertyName});
        }
        builder.addMethod(getMethod.build());
        builder.addMethod(setMethod.build());
    }

    private void generateStaticMetadata(TypeSpec.Builder typeBuilder) {
        ClassName targetName = this.entity.isImmutable() ? ClassName.get((TypeElement)this.entity.element()) : this.typeName;
        for (Map.Entry<Element, ? extends AttributeDescriptor> entry : this.entity.attributes().entrySet()) {
            AttributeDescriptor attribute = entry.getValue();
            if (attribute.isTransient()) continue;
            FieldSpec field = this.generateAttribute(attribute, (TypeName)targetName);
            typeBuilder.addField(field);
        }
        this.generateType(typeBuilder);
    }

    private FieldSpec generateAttribute(AttributeDescriptor attribute, TypeName targetName) {
        ParameterizedTypeName attributeTypeName;
        TypeMirror typeMirror = attribute.typeMirror();
        if (attribute.isIterable()) {
            typeMirror = EntityGenerator.tryFirstTypeArgument(attribute.typeMirror());
            attributeTypeName = this.parameterizedCollectionName(attribute.typeMirror());
        } else if (attribute.isOptional()) {
            typeMirror = EntityGenerator.tryFirstTypeArgument(attribute.typeMirror());
            attributeTypeName = TypeName.get((TypeMirror)typeMirror);
        } else {
            attributeTypeName = this.nameResolver.generatedTypeNameOf(typeMirror).orElse(null);
        }
        if (attributeTypeName == null) {
            attributeTypeName = this.boxedTypeName(typeMirror);
        }
        boolean isQueryable = attribute.cardinality() == null || attribute.isForeignKey();
        Class attributeType = isQueryable ? QueryAttribute.class : Attribute.class;
        ParameterizedTypeName type = EntityGenerator.parameterizedTypeName(attributeType, new TypeName[]{targetName, attributeTypeName});
        String attributeName = Names.upperCaseUnderscore(Names.removeMemberPrefixes(attribute.fieldName()));
        this.fieldNames.add(attributeName);
        FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)type, (String)attributeName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        CodeBlock.Builder builder = CodeBlock.builder();
        if (attribute.isIterable()) {
            typeMirror = EntityGenerator.tryFirstTypeArgument(typeMirror);
            TypeName name = this.nameResolver.tryGeneratedTypeName(typeMirror);
            TypeElement collectionElement = (TypeElement)this.types.asElement(attribute.typeMirror());
            ParameterizedTypeName builderName = EntityGenerator.parameterizedTypeName(attribute.builderClass(), new TypeName[]{targetName, attributeTypeName, name});
            builder.add("\nnew $T($S, $T.class, $T.class)\n", new Object[]{builderName, attribute.name(), ClassName.get((TypeElement)collectionElement), name});
        } else if (attribute.isMap()) {
            List<TypeMirror> parameters = Mirrors.listGenericTypeArguments(typeMirror);
            TypeName keyName = TypeName.get((TypeMirror)parameters.get(0));
            typeMirror = parameters.get(1);
            TypeName valueName = this.nameResolver.tryGeneratedTypeName(typeMirror);
            TypeElement valueElement = (TypeElement)this.types.asElement(attribute.typeMirror());
            ParameterizedTypeName builderName = EntityGenerator.parameterizedTypeName(attribute.builderClass(), new TypeName[]{targetName, attributeTypeName, keyName, valueName});
            builder.add("\nnew $T($S, $T.class, $T.class, $T.class)\n", new Object[]{builderName, attribute.name(), ClassName.get((TypeElement)valueElement), keyName, valueName});
        } else {
            ParameterizedTypeName builderName = EntityGenerator.parameterizedTypeName(attribute.builderClass(), new TypeName[]{targetName, attributeTypeName});
            ParameterizedTypeName classType = attributeTypeName;
            if (typeMirror.getKind().isPrimitive()) {
                classType = TypeName.get((TypeMirror)typeMirror);
            }
            builder.add("\nnew $T($S, $T.class)\n", new Object[]{builderName, attribute.name(), classType});
        }
        this.generateProperties(attribute, typeMirror, targetName, (TypeName)attributeTypeName, builder);
        if (attribute.isKey()) {
            builder.add(".setKey(true)\n", new Object[0]);
        }
        builder.add(".setGenerated($L)\n", new Object[]{attribute.isGenerated()});
        builder.add(".setLazy($L)\n", new Object[]{attribute.isLazy()});
        builder.add(".setNullable($L)\n", new Object[]{attribute.isNullable()});
        builder.add(".setUnique($L)\n", new Object[]{attribute.isUnique()});
        if (!Names.isEmpty(attribute.defaultValue())) {
            builder.add(".setDefaultValue($S)\n", new Object[]{attribute.defaultValue()});
        }
        if (!Names.isEmpty(attribute.collate())) {
            builder.add(".setCollate($S)\n", new Object[]{attribute.collate()});
        }
        if (attribute.columnLength() != null) {
            builder.add(".setLength($L)\n", new Object[]{attribute.columnLength()});
        }
        if (attribute.isVersion()) {
            builder.add(".setVersion($L)\n", new Object[]{attribute.isVersion()});
        }
        if (attribute.converterName() != null) {
            builder.add(".setConverter(new $L())\n", new Object[]{attribute.converterName()});
        }
        if (attribute.isForeignKey()) {
            builder.add(".setForeignKey($L)\n", new Object[]{attribute.isForeignKey()});
            this.graph.referencingEntity(attribute).ifPresent(referenced -> {
                builder.add(".setReferencedClass($T.class)\n", new Object[]{referenced.isImmutable() ? TypeName.get((TypeMirror)referenced.element().asType()) : this.nameResolver.typeNameOf((EntityDescriptor)referenced)});
                this.graph.referencingAttribute(attribute, (EntityDescriptor)referenced).ifPresent(referencedAttribute -> {
                    String name = Names.upperCaseUnderscore(referencedAttribute.fieldName());
                    TypeSpec provider = CodeGeneration.createAnonymousSupplier((TypeName)ClassName.get(Attribute.class), CodeBlock.builder().addStatement("return $T.$L", new Object[]{this.nameResolver.typeNameOf((EntityDescriptor)referenced), name}).build());
                    builder.add(".setReferencedAttribute($L)\n", new Object[]{provider});
                });
            });
        }
        if (attribute.isIndexed()) {
            builder.add(".setIndexed($L)\n", new Object[]{attribute.isIndexed()});
            if (!Names.isEmpty(attribute.indexName())) {
                builder.add(".setIndexName($S)\n", new Object[]{attribute.indexName()});
            }
        }
        if (attribute.referentialAction() != null) {
            builder.add(".setReferentialAction($T.$L)\n", new Object[]{ClassName.get(ReferentialAction.class), attribute.referentialAction()});
        }
        if (!attribute.cascadeActions().isEmpty()) {
            StringJoiner joiner = new StringJoiner(",");
            attribute.cascadeActions().forEach(action -> joiner.add("$T.$L"));
            int index = 0;
            ClassName cascadeClass = ClassName.get(CascadeAction.class);
            Object[] args = new Object[attribute.cascadeActions().size() * 2];
            for (CascadeAction action2 : attribute.cascadeActions()) {
                args[index++] = cascadeClass;
                args[index++] = action2;
            }
            builder.add(".setCascadeAction(" + joiner + ")\n", args);
        }
        if (attribute.cardinality() != null) {
            builder.add(".setCardinality($T.$L)\n", new Object[]{ClassName.get(Cardinality.class), attribute.cardinality()});
            Optional<EntityDescriptor> referencingEntity = this.graph.referencingEntity(attribute);
            if (referencingEntity.isPresent()) {
                EntityDescriptor referenced2 = referencingEntity.get();
                Set<AttributeDescriptor> mappings = this.graph.mappedAttributes(this.entity, attribute, referenced2);
                if (attribute.cardinality() == Cardinality.MANY_TO_MANY) {
                    AttributeDescriptor mapped;
                    ClassName junctionType = null;
                    if (attribute.associativeEntity().isPresent()) {
                        junctionType = this.nameResolver.generatedJoinEntityName(attribute.associativeEntity().get(), this.entity, referenced2);
                        this.generateJunctionType(attribute);
                    } else if (mappings.size() == 1 && (mapped = mappings.iterator().next()).associativeEntity().isPresent()) {
                        junctionType = this.nameResolver.generatedJoinEntityName(mapped.associativeEntity().get(), referenced2, this.entity);
                    }
                    if (junctionType != null) {
                        builder.add(".setReferencedClass($T.class)\n", new Object[]{junctionType});
                    }
                }
                if (mappings.size() == 1) {
                    AttributeDescriptor mapped = mappings.iterator().next();
                    String staticMemberName = Names.upperCaseUnderscore(mapped.fieldName());
                    TypeSpec provider = CodeGeneration.createAnonymousSupplier((TypeName)ClassName.get(Attribute.class), CodeBlock.builder().addStatement("return $T.$L", new Object[]{this.nameResolver.typeNameOf(referenced2), staticMemberName}).build());
                    builder.add(".setMappedAttribute($L)\n", new Object[]{provider});
                }
            }
        }
        builder.add(".build()", new Object[0]);
        return fieldBuilder.initializer("$L", new Object[]{builder.build()}).build();
    }

    private void generateProperties(AttributeDescriptor attribute, TypeMirror typeMirror, TypeName targetName, TypeName attributeTypeName, CodeBlock.Builder builder) {
        Class propertyClass = this.propertyClassFor(typeMirror);
        ParameterizedTypeName propertyType = this.propertyName(propertyClass, targetName, attributeTypeName);
        TypeSpec.Builder propertyBuilder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)propertyType);
        boolean isNullable = typeMirror.getKind().isPrimitive() && attribute.isNullable();
        String fieldName = this.entity.isImmutable() ? attribute.getterName() + "()" : attribute.fieldName();
        GeneratedProperty boxed = new GeneratedProperty.Builder(fieldName, targetName, attributeTypeName).setNullable(isNullable).setReadOnly(this.entity.isImmutable()).build();
        this.addPropertyMethods(propertyBuilder, boxed);
        if (propertyClass != Property.class) {
            TypeName primitiveType = TypeName.get((TypeMirror)attribute.typeMirror());
            String name = Names.upperCaseFirst(attribute.typeMirror().toString());
            this.addPropertyMethods(propertyBuilder, new GeneratedProperty.Builder(fieldName, targetName, primitiveType).setSuffix(name).setReadOnly(this.entity.isImmutable()).build());
        }
        builder.add(".setProperty($L)\n", new Object[]{propertyBuilder.build()});
        if (!this.entity.isStateless()) {
            ClassName stateClass = ClassName.get(PropertyState.class);
            TypeSpec.Builder propertyStateType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)EntityGenerator.parameterizedTypeName(Property.class, new TypeName[]{targetName, stateClass}));
            this.addPropertyMethods(propertyStateType, new GeneratedProperty.Builder(this.propertyStateFieldName(attribute), targetName, (TypeName)stateClass).build());
            builder.add(".setPropertyState($L)\n", new Object[]{propertyStateType.build()});
        }
        if (this.entity.isImmutable()) {
            boolean useSetter;
            ClassName builderName;
            String propertyName;
            if (this.entity.builderType().isPresent()) {
                TypeElement builderType = this.entity.builderType().get();
                propertyName = attribute.setterName();
                builderName = TypeName.get((TypeMirror)builderType.asType());
                useSetter = true;
                for (ExecutableElement method : ElementFilter.methodsIn(builderType.getEnclosedElements())) {
                    List<? extends VariableElement> parameters = method.getParameters();
                    String name = Names.removeMethodPrefixes(method.getSimpleName());
                    if ((!name.startsWith("with") || name.length() <= 4 || !Character.isUpperCase(name.charAt(4))) && (!name.equalsIgnoreCase(attribute.fieldName()) || parameters.size() != 1)) continue;
                    propertyName = method.getSimpleName().toString();
                    break;
                }
            } else {
                propertyName = attribute.fieldName();
                builderName = this.typeName;
                useSetter = false;
            }
            propertyType = this.propertyName(propertyClass, (TypeName)builderName, attributeTypeName);
            TypeSpec.Builder builderProperty = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)propertyType);
            this.addPropertyMethods(builderProperty, new GeneratedProperty.Builder(propertyName, (TypeName)builderName, attributeTypeName).setWriteOnly(true).setSetter(useSetter).build());
            if (propertyClass != Property.class) {
                TypeName primitiveType = TypeName.get((TypeMirror)attribute.typeMirror());
                String name = Names.upperCaseFirst(attribute.typeMirror().toString());
                this.addPropertyMethods(builderProperty, new GeneratedProperty.Builder(propertyName, (TypeName)builderName, primitiveType).setSuffix(name).setSetter(useSetter).setWriteOnly(true).build());
            }
            builder.add(".setBuilderProperty($L)\n", new Object[]{builderProperty.build()});
        }
    }

    private ParameterizedTypeName propertyName(Class type, TypeName targetName, TypeName fieldName) {
        if (type == Property.class) {
            return EntityGenerator.parameterizedTypeName(type, targetName, fieldName);
        }
        return EntityGenerator.parameterizedTypeName(type, targetName);
    }

    private Class propertyClassFor(TypeMirror typeMirror) {
        Class<Property> propertyClass = Property.class;
        if (typeMirror.getKind().isPrimitive()) {
            switch (typeMirror.getKind()) {
                case BOOLEAN: {
                    propertyClass = BooleanProperty.class;
                    break;
                }
                case BYTE: {
                    propertyClass = ByteProperty.class;
                    break;
                }
                case SHORT: {
                    propertyClass = ShortProperty.class;
                    break;
                }
                case INT: {
                    propertyClass = IntProperty.class;
                    break;
                }
                case LONG: {
                    propertyClass = LongProperty.class;
                    break;
                }
                case FLOAT: {
                    propertyClass = FloatProperty.class;
                    break;
                }
                case DOUBLE: {
                    propertyClass = DoubleProperty.class;
                }
            }
        }
        return propertyClass;
    }

    private String propertyStateFieldName(AttributeDescriptor attribute) {
        return "$" + attribute.fieldName() + "_state";
    }

    private void generateJunctionType(AttributeDescriptor attribute) {
        this.graph.referencingEntity(attribute).ifPresent(referencing -> {
            JoinEntityGenerator generator = new JoinEntityGenerator(this.processingEnvironment, this.nameResolver, this.entity, (EntityDescriptor)referencing, attribute);
            try {
                generator.generate();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private TypeName boxedTypeName(TypeMirror typeMirror) {
        if (typeMirror.getKind().isPrimitive()) {
            TypeElement boxed = this.types.boxedClass((PrimitiveType)typeMirror);
            return TypeName.get((TypeMirror)boxed.asType());
        }
        return TypeName.get((TypeMirror)typeMirror);
    }

    private ParameterizedTypeName parameterizedCollectionName(TypeMirror typeMirror) {
        TypeMirror genericType = EntityGenerator.tryFirstTypeArgument(typeMirror);
        TypeName elementName = this.nameResolver.tryGeneratedTypeName(genericType);
        TypeElement collectionElement = (TypeElement)this.types.asElement(typeMirror);
        ClassName collectionName = ClassName.get((TypeElement)collectionElement);
        return ParameterizedTypeName.get((ClassName)collectionName, (TypeName[])new TypeName[]{elementName});
    }

    private static TypeMirror tryFirstTypeArgument(TypeMirror typeMirror) {
        List<TypeMirror> args = Mirrors.listGenericTypeArguments(typeMirror);
        return args.isEmpty() ? typeMirror : args.get(0);
    }

    private static ParameterizedTypeName parameterizedTypeName(Class<?> rawType, TypeName ... typeArguments) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(rawType), (TypeName[])typeArguments);
    }
}

