/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.processor.Mirrors;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

class ElementValidator {
    private final Element element;
    private final Messager messager;
    private boolean hasErrors;
    private boolean hasWarnings;

    ElementValidator(Element element, ProcessingEnvironment processingEnvironment) {
        this.element = element;
        this.messager = processingEnvironment.getMessager();
    }

    public void error(String message) {
        this.hasErrors = true;
        this.messager.printMessage(Diagnostic.Kind.ERROR, message, this.element);
    }

    public void error(String message, Class<? extends Annotation> annotation) {
        this.hasErrors = true;
        String name = annotation.getName();
        Optional<? extends AnnotationMirror> mirror = Mirrors.findAnnotationMirror(this.element, name);
        if (mirror.isPresent()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, message, this.element, mirror.get());
        } else {
            this.messager.printMessage(Diagnostic.Kind.ERROR, message);
        }
    }

    public void warning(String message) {
        this.hasWarnings = true;
        this.messager.printMessage(Diagnostic.Kind.WARNING, message, this.element);
    }

    public void warning(String message, Class<? extends Annotation> annotation) {
        this.hasWarnings = true;
        String name = annotation.getName();
        Optional<? extends AnnotationMirror> mirror = Mirrors.findAnnotationMirror(this.element, name);
        if (mirror.isPresent()) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, message, this.element, mirror.get());
        } else {
            this.messager.printMessage(Diagnostic.Kind.WARNING, message);
        }
    }

    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    static boolean hasErrors(Set<ElementValidator> validators) {
        for (ElementValidator validator : validators) {
            if (!validator.hasErrors()) continue;
            return true;
        }
        return false;
    }
}

