/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.requery.processor.EntityProcessor;
import io.requery.util.function.Supplier;
import java.io.IOException;
import javax.annotation.Generated;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.Elements;

class CodeGeneration {
    private CodeGeneration() {
    }

    static void addGeneratedAnnotation(ProcessingEnvironment processingEnvironment, TypeSpec.Builder builder) {
        Elements elements = processingEnvironment.getElementUtils();
        if (elements.getTypeElement(Generated.class.getCanonicalName()) != null) {
            builder.addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{EntityProcessor.class.getCanonicalName()}).build());
        }
    }

    static TypeSpec createAnonymousSupplier(TypeName type, CodeBlock block) {
        return TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Supplier.class), (TypeName[])new TypeName[]{type})).addMethod(CodeGeneration.overridePublicMethod("get").addCode(block).returns(type).build()).build();
    }

    static MethodSpec.Builder overridePublicMethod(String name) {
        return MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class);
    }

    static void writeType(ProcessingEnvironment processingEnvironment, String packageName, TypeSpec typeSpec) throws IOException {
        JavaFile file = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).addFileComment("Generated file do not edit, generated by " + EntityProcessor.class.getCanonicalName(), new Object[0]).indent("    ").build();
        file.writeTo(processingEnvironment.getFiler());
    }
}

