/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.requery.processor.CodeGeneration;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.Mirrors;
import io.requery.processor.TypeGenerationExtension;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;

class AndroidParcelableExtension
implements TypeGenerationExtension {
    private static final String PACKAGE_ANDROID_OS = "android.os";
    private static final String PACKAGE_PARCELER = "io.requery.android";
    private final Types types;

    AndroidParcelableExtension(Types types) {
        this.types = types;
    }

    @Override
    public void generate(EntityDescriptor entity, TypeSpec.Builder builder) {
        TypeElement typeElement = entity.element();
        if (!Mirrors.isInstance(this.types, typeElement, "android.os.Parcelable") || Mirrors.overridesMethod(this.types, typeElement, "writeToParcel")) {
            return;
        }
        ClassName className = ClassName.bestGuess((String)entity.typeName().toString());
        ParameterizedTypeName creatorType = ParameterizedTypeName.get((ClassName)ClassName.get((String)PACKAGE_ANDROID_OS, (String)"Parcelable.Creator", (String[])new String[0]), (TypeName[])new TypeName[]{className});
        ClassName parcelName = ClassName.get((String)PACKAGE_ANDROID_OS, (String)"Parcel", (String[])new String[0]);
        ClassName parcelableName = ClassName.get((String)PACKAGE_ANDROID_OS, (String)"Parcelable", (String[])new String[0]);
        builder.addSuperinterface((TypeName)parcelableName);
        TypeSpec.Builder creatorBuilder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)creatorType).addMethod(CodeGeneration.overridePublicMethod("createFromParcel").addParameter(ParameterSpec.builder((TypeName)parcelName, (String)"source", (Modifier[])new Modifier[0]).build()).addStatement("return PARCELER.readFromParcel(source)", new Object[0]).returns((TypeName)className).build()).addMethod(CodeGeneration.overridePublicMethod("newArray").addParameter(TypeName.INT, "size", new Modifier[0]).addStatement("return new $T[size]", new Object[]{className}).returns((TypeName)ArrayTypeName.of((TypeName)className)).build());
        builder.addField(FieldSpec.builder((TypeName)creatorType, (String)"CREATOR", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$L", new Object[]{creatorBuilder.build()}).build());
        builder.addMethod(CodeGeneration.overridePublicMethod("describeContents").returns(TypeName.INT).addStatement("return 0", new Object[0]).build());
        builder.addMethod(CodeGeneration.overridePublicMethod("writeToParcel").returns(TypeName.VOID).addParameter((TypeName)parcelName, "dest", new Modifier[0]).addParameter(TypeName.INT, "flags", new Modifier[0]).addStatement("PARCELER.writeToParcel(this, dest)", new Object[0]).build());
        ParameterizedTypeName parcelerType = ParameterizedTypeName.get((ClassName)ClassName.get((String)PACKAGE_PARCELER, (String)"EntityParceler", (String[])new String[0]), (TypeName[])new TypeName[]{className});
        builder.addField(FieldSpec.builder((TypeName)parcelerType, (String)"PARCELER", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T($L)", new Object[]{parcelerType, "$TYPE"}).build());
    }
}

