/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.requery.processor.AttributeDescriptor;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.Mirrors;
import io.requery.processor.Names;
import io.requery.processor.PropertyGenerationExtension;
import io.requery.processor.TypeGenerationExtension;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

class AndroidObservableExtension
implements TypeGenerationExtension,
PropertyGenerationExtension {
    private static final String BINDING_PACKAGE = "android.databinding";
    private final EntityDescriptor entity;
    private final ProcessingEnvironment processingEnvironment;
    private final boolean observable;

    AndroidObservableExtension(EntityDescriptor entity, ProcessingEnvironment processingEnvironment) {
        this.entity = entity;
        this.processingEnvironment = processingEnvironment;
        this.observable = this.isObservable();
    }

    private boolean isObservable() {
        String[] types = new String[]{"android.databinding.BaseObservable", "android.databinding.Observable"};
        TypeElement element = this.entity.element();
        return Arrays.stream(types).anyMatch(name -> Mirrors.isInstance(this.processingEnvironment.getTypeUtils(), element, name));
    }

    private boolean isBindable(AttributeDescriptor descriptor) {
        Element element = descriptor.element();
        return Mirrors.findAnnotationMirror(element, "android.databinding.Bindable").isPresent();
    }

    @Override
    public void generate(EntityDescriptor entity, TypeSpec.Builder builder) {
        if (this.isObservable() && entity.element().getKind().isInterface()) {
            builder.superclass((TypeName)ClassName.get((String)BINDING_PACKAGE, (String)"BaseObservable", (String[])new String[0]));
        }
    }

    @Override
    public void addToGetter(AttributeDescriptor member, MethodSpec.Builder builder) {
        if (this.observable && this.isBindable(member)) {
            builder.addAnnotation(ClassName.get((String)BINDING_PACKAGE, (String)"Bindable", (String[])new String[0]));
        }
    }

    @Override
    public void addToSetter(AttributeDescriptor member, MethodSpec.Builder builder) {
        Optional<String> modulePackage;
        if (!this.observable || !this.isBindable(member)) {
            return;
        }
        Elements elements = this.processingEnvironment.getElementUtils();
        String bindingInfo = "android.databinding.layouts.DataBindingInfo";
        TypeElement dataBindingType = elements.getTypeElement(bindingInfo);
        ClassName BRclass = null;
        if (dataBindingType != null && (modulePackage = Mirrors.findAnnotationMirror((Element)dataBindingType, "android.databinding.BindingBuildInfo").map(mirror -> Mirrors.findAnnotationValue(mirror, "modulePackage")).filter(Optional::isPresent).map(Optional::get).map(AnnotationValue::toString)).isPresent()) {
            BRclass = ClassName.get((String)modulePackage.get().replaceAll("\"", ""), (String)"BR", (String[])new String[0]);
        }
        if (BRclass == null) {
            PackageElement packageElement = elements.getPackageOf(this.entity.element());
            String packageName = packageElement.getQualifiedName().toString();
            BRclass = ClassName.get((String)packageName, (String)"BR", (String[])new String[0]);
        }
        String propertyName = member.setterName().replaceFirst("set", "");
        propertyName = Names.lowerCaseFirst(propertyName);
        builder.addStatement("notifyPropertyChanged($L.$L)", new Object[]{BRclass, propertyName});
    }
}

