/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

enum SourceLanguage {
    JAVA,
    KOTLIN;

    private static final Map<TypeElement, SourceLanguage> map;

    static SourceLanguage of(TypeElement element) {
        if (map.containsKey(element)) {
            return map.get(element);
        }
        return JAVA;
    }

    static void map(ProcessingEnvironment environment) {
        map.clear();
        try {
            SourceLanguage.readKaptTypes(environment, map);
        }
        catch (IOException e) {
            environment.getMessager().printMessage(Diagnostic.Kind.WARNING, e.toString());
        }
    }

    private static void readKaptTypes(ProcessingEnvironment environment, Map<TypeElement, SourceLanguage> map) throws IOException {
        String path = environment.getOptions().get("kapt.annotations");
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        try (FileInputStream input = new FileInputStream(file);
             BufferedReader buffered = new BufferedReader(new InputStreamReader(input));){
            String line;
            String annotationType = null;
            String packageName = null;
            while ((line = buffered.readLine()) != null) {
                String classType = null;
                String[] parts = line.split(" ");
                switch (parts[0]) {
                    case "p": {
                        packageName = parts[1];
                        break;
                    }
                    case "a": {
                        annotationType = parts[1];
                        break;
                    }
                    case "c": {
                        classType = parts[2];
                        break;
                    }
                }
                if (classType == null || annotationType == null) continue;
                parts = classType.split("/");
                String name = parts[parts.length - 1];
                String qname = packageName + "." + name;
                TypeElement element = environment.getElementUtils().getTypeElement(qname);
                if (element == null) continue;
                map.put(element, KOTLIN);
            }
        }
    }

    static {
        map = new LinkedHashMap<TypeElement, SourceLanguage>();
    }
}

