/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.processor.Names;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Name;

class QualifiedName
implements Name {
    private final String packageName;
    private final String className;

    QualifiedName(String packageName, String className) {
        if (Names.isEmpty(className)) {
            throw new IllegalArgumentException("Empty class name");
        }
        if (!SourceVersion.isIdentifier(className)) {
            throw new IllegalArgumentException("Invalid class name identifier: " + className);
        }
        this.packageName = packageName;
        this.className = className;
    }

    QualifiedName(String qualifiedName) {
        String[] parts = qualifiedName.split("\\.");
        String className = "";
        StringBuilder sb = new StringBuilder();
        if (parts.length != 0) {
            for (String part : parts) {
                if (Character.isLowerCase(part.charAt(0))) {
                    sb.append(part);
                    sb.append(".");
                    continue;
                }
                className = part;
            }
        } else {
            className = qualifiedName;
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '.') {
            sb.deleteCharAt(sb.length() - 1);
        }
        if (Names.isEmpty(className)) {
            throw new IllegalArgumentException("Empty class name");
        }
        if (!SourceVersion.isIdentifier(className)) {
            throw new IllegalArgumentException("Invalid class name identifier: " + className);
        }
        this.packageName = sb.toString();
        this.className = className;
    }

    String packageName() {
        return this.packageName;
    }

    String className() {
        return this.className;
    }

    @Override
    public boolean contentEquals(CharSequence cs) {
        return this.toString().equals(cs.toString());
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Name) {
            Name other = (Name)obj;
            return other.contentEquals(this.toString());
        }
        return false;
    }

    @Override
    public String toString() {
        return Names.isEmpty(this.packageName) ? this.className : this.packageName + "." + this.className;
    }
}

