/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.Column;
import io.requery.ForeignKey;
import io.requery.JunctionTable;
import io.requery.ReferentialAction;
import io.requery.processor.AssociativeEntityDescriptor;
import io.requery.processor.AssociativeReference;
import io.requery.processor.AttributeMember;
import io.requery.processor.Mirrors;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

class JunctionTableAssociation
implements AssociativeEntityDescriptor {
    private final JunctionTable table;
    private final Set<AssociativeReference> columns;
    private final TypeMirror typeMirror;

    JunctionTableAssociation(Elements elements, AttributeMember member, JunctionTable table) {
        TypeMirror mirror;
        block6: {
            this.table = table;
            this.columns = new LinkedHashSet<AssociativeReference>();
            for (Column column : table.columns()) {
                ForeignKey key = column.foreignKey()[0];
                String columnName = column.name();
                ReferentialAction deleteAction = ReferentialAction.CASCADE;
                ReferentialAction updateAction = ReferentialAction.CASCADE;
                TypeElement referenceType = null;
                if (key != null) {
                    deleteAction = key.delete();
                    updateAction = key.update();
                    Optional value = Mirrors.findAnnotationMirror(member.element(), JunctionTable.class).flatMap(m -> Mirrors.findAnnotationValue(m, "columns"));
                    if (value.isPresent()) {
                        List mirrors = (List)((AnnotationValue)value.get()).getValue();
                        for (Object m2 : mirrors) {
                            List children;
                            Optional<AnnotationValue> annotationValue;
                            Optional<AnnotationValue> keyValue = Mirrors.findAnnotationValue((AnnotationMirror)m2, "foreignKey");
                            if (!keyValue.isPresent() || !(annotationValue = Mirrors.findAnnotationValue((AnnotationMirror)(children = (List)keyValue.get().getValue()).get(0), "references")).isPresent()) continue;
                            referenceType = elements.getTypeElement(annotationValue.get().getValue().toString());
                        }
                    }
                }
                this.columns.add(new AssociativeReference(columnName, referenceType, deleteAction, updateAction));
            }
            mirror = null;
            try {
                table.type();
            }
            catch (MirroredTypeException e) {
                if (e.getTypeMirror().toString().equals("void")) break block6;
                mirror = e.getTypeMirror();
            }
        }
        this.typeMirror = mirror;
    }

    @Override
    public String name() {
        return this.table.name();
    }

    @Override
    public Set<AssociativeReference> columns() {
        return this.columns;
    }

    @Override
    public Optional<TypeMirror> type() {
        return Optional.ofNullable(this.typeMirror);
    }
}

