/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.ReferentialAction;
import io.requery.processor.AssociativeEntityDescriptor;
import io.requery.processor.AssociativeReference;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import javax.persistence.ConstraintMode;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;

class JoinTableAssociation
implements AssociativeEntityDescriptor {
    private final JoinTable table;
    private final Set<AssociativeReference> columns;

    JoinTableAssociation(JoinTable table) {
        ReferentialAction action;
        ForeignKey foreignKey;
        String columnName;
        this.table = table;
        this.columns = new LinkedHashSet<AssociativeReference>();
        for (JoinColumn column : table.joinColumns()) {
            columnName = column.name();
            foreignKey = column.foreignKey();
            action = this.mapConstraint(foreignKey.value());
            this.columns.add(new AssociativeReference(columnName, null, action, action));
        }
        for (JoinColumn column : table.inverseJoinColumns()) {
            columnName = column.name();
            foreignKey = column.foreignKey();
            action = this.mapConstraint(foreignKey.value());
            this.columns.add(new AssociativeReference(columnName, null, action, action));
        }
    }

    private ReferentialAction mapConstraint(ConstraintMode constraint) {
        switch (constraint) {
            case NO_CONSTRAINT: {
                return ReferentialAction.NO_ACTION;
            }
        }
        return ReferentialAction.CASCADE;
    }

    @Override
    public String name() {
        return this.table.name();
    }

    @Override
    public Set<AssociativeReference> columns() {
        return this.columns;
    }

    @Override
    public Optional<TypeMirror> type() {
        return Optional.empty();
    }
}

