/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.com.squareup.javapoet.CodeBlock;
import io.requery.com.squareup.javapoet.MethodSpec;
import io.requery.com.squareup.javapoet.TypeName;
import io.requery.com.squareup.javapoet.TypeSpec;
import io.requery.processor.CodeGeneration;
import javax.lang.model.element.Modifier;

class GeneratedProperty {
    private final String readName;
    private final String writeName;
    private final TypeName targetName;
    private final TypeName propertyTypeName;
    private String methodSuffix = "";
    private boolean useMethod;
    private boolean isNullable;
    private boolean isReadOnly;
    private boolean isWriteOnly;

    GeneratedProperty(String propertyName, TypeName targetName, TypeName propertyTypeName) {
        this(propertyName, propertyName, targetName, propertyTypeName);
    }

    GeneratedProperty(String readName, String writeName, TypeName targetName, TypeName propertyTypeName) {
        this.readName = readName;
        this.writeName = writeName;
        this.targetName = targetName;
        this.propertyTypeName = propertyTypeName;
    }

    GeneratedProperty setUseMethod(boolean useMethod) {
        this.useMethod = useMethod;
        return this;
    }

    GeneratedProperty setSuffix(String suffix) {
        this.methodSuffix = suffix;
        return this;
    }

    GeneratedProperty setNullable(boolean nullable) {
        this.isNullable = nullable;
        return this;
    }

    GeneratedProperty setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
        return this;
    }

    GeneratedProperty setWriteOnly(boolean writeOnly) {
        this.isWriteOnly = writeOnly;
        return this;
    }

    void build(TypeSpec.Builder builder) {
        this.addPropertyMethods(builder);
    }

    private void addPropertyMethods(TypeSpec.Builder builder) {
        String suffix = this.methodSuffix;
        MethodSpec.Builder getMethod = CodeGeneration.overridePublicMethod("get" + suffix).addParameter(this.targetName, "entity", new Modifier[0]).returns(this.propertyTypeName);
        if (this.isWriteOnly) {
            getMethod.addStatement("throw new UnsupportedOperationException()", new Object[0]);
        } else {
            getMethod.addStatement(this.useMethod ? "return entity.$L()" : "return entity.$L", this.readName);
        }
        MethodSpec.Builder setMethod = CodeGeneration.overridePublicMethod("set" + suffix).addParameter(this.targetName, "entity", new Modifier[0]).addParameter(this.propertyTypeName, "value", new Modifier[0]);
        if (this.isReadOnly) {
            setMethod.addStatement("throw new UnsupportedOperationException()", new Object[0]);
        } else {
            CodeBlock.Builder setterBlock = CodeBlock.builder();
            if (this.isNullable) {
                setterBlock.beginControlFlow("if(value != null)", new Object[0]);
            }
            setterBlock.addStatement(this.useMethod ? "entity.$L(value)" : "entity.$L = value", this.writeName);
            if (this.isNullable) {
                setterBlock.endControlFlow();
            }
            setMethod.addCode(setterBlock.build());
        }
        builder.addMethod(getMethod.build());
        builder.addMethod(setMethod.build());
    }
}

