/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.Entity;
import io.requery.Superclass;
import io.requery.processor.ElementValidator;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.EntityGenerator;
import io.requery.processor.EntityGraph;
import io.requery.processor.EntityGraphValidator;
import io.requery.processor.EntityType;
import io.requery.processor.Mirrors;
import io.requery.processor.ModelGenerator;
import io.requery.processor.SourceGenerator;
import io.requery.processor.SourceLanguage;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.persistence.MappedSuperclass;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"io.requery.*", "javax.persistence.*"})
@SupportedOptions(value={"generate.model", "generate.always", "generate.jpa"})
public final class EntityProcessor
extends AbstractProcessor {
    static final String GENERATE_MODEL = "generate.model";
    static final String GENERATE_ALWAYS = "generate.always";
    static final String GENERATE_JPA = "generate.jpa";
    private Map<String, EntityGraph> graphs;
    private Map<TypeElement, EntityType> superTypes;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.graphs = new LinkedHashMap<String, EntityGraph>();
        this.superTypes = new LinkedHashMap<TypeElement, EntityType>();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<ElementValidator> results;
        HashMap entities = new HashMap();
        SourceLanguage.map(this.processingEnv);
        Types types = this.processingEnv.getTypeUtils();
        for (TypeElement typeElement2 : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement2)) {
                this.typeElementOf(element).ifPresent(typeElement -> {
                    if (this.isEntity((TypeElement)typeElement)) {
                        EntityType entity = this.computeType(entities, (TypeElement)typeElement);
                        entity.addAnnotationElement(annotation, (Element)((Object)element));
                        String model = entity.modelName();
                        this.graphs.computeIfAbsent(model, key -> new EntityGraph(types)).add(entity);
                    } else if (this.isSuperclass((TypeElement)typeElement)) {
                        EntityType entity = this.computeType(this.superTypes, (TypeElement)typeElement);
                        entity.addAnnotationElement(annotation, (Element)((Object)element));
                    }
                });
            }
        }
        boolean hasErrors = false;
        LinkedHashSet<ElementValidator> linkedHashSet = new LinkedHashSet<ElementValidator>();
        Elements elements = this.processingEnv.getElementUtils();
        for (EntityType entityType : entities.values()) {
            TypeElement superElement;
            void var10_22;
            TypeMirror typeMirror = ((TypeElement)entityType.element()).getSuperclass();
            while (var10_22.getKind() != TypeKind.NONE && (superElement = elements.getTypeElement(var10_22.toString())) != null) {
                EntityType superType = this.superTypes.get(superElement);
                if (superType == null && this.isSuperclass(superElement)) {
                    superType = this.computeType(this.superTypes, superElement);
                }
                if (superType != null) {
                    superType.process(this.processingEnv);
                    entityType.merge(superType);
                }
                TypeMirror typeMirror2 = superElement.getSuperclass();
            }
            results = entityType.process(this.processingEnv);
            linkedHashSet.addAll(results);
        }
        for (EntityGraph entityGraph : this.graphs.values()) {
            EntityGraphValidator entityGraphValidator = new EntityGraphValidator(this.processingEnv, entityGraph);
            results = entityGraphValidator.validate();
            linkedHashSet.addAll(results);
        }
        if (ElementValidator.hasErrors(linkedHashSet)) {
            hasErrors = true;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "model has errors code generation may fail");
        }
        LinkedHashSet<EntityGenerator> linkedHashSet2 = new LinkedHashSet<EntityGenerator>();
        if (!hasErrors || this.getOption(GENERATE_ALWAYS, true)) {
            for (EntityDescriptor entityDescriptor : entities.values()) {
                EntityGraph graph = this.graphs.get(entityDescriptor.modelName());
                if (graph == null) continue;
                linkedHashSet2.add(new EntityGenerator(this.processingEnv, graph, entityDescriptor));
            }
        }
        if (this.getOption(GENERATE_MODEL, true)) {
            LinkedHashMap<String, LinkedHashSet<EntityDescriptor>> linkedHashMap = new LinkedHashMap<String, LinkedHashSet<EntityDescriptor>>();
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (EntityType entity : entities.values()) {
                EntityGraph graph = this.graphs.get(entity.modelName());
                String packageName = this.findModelPackageName(graph);
                hashMap.computeIfAbsent(packageName, key -> true);
                if (entity.generatesAdditionalTypes()) {
                    hashMap.put(packageName, false);
                }
                if (linkedHashMap.containsKey(packageName)) {
                    ((Collection)linkedHashMap.get(packageName)).addAll(graph.entities());
                    continue;
                }
                linkedHashMap.put(packageName, new LinkedHashSet<EntityDescriptor>(graph.entities()));
            }
            linkedHashSet2.addAll(linkedHashMap.entrySet().stream().filter(entry -> !((Collection)entry.getValue()).isEmpty()).filter(entry -> (Boolean)canGenerate.get(entry.getKey())).map(entry -> new ModelGenerator(this.processingEnv, (String)entry.getKey(), (Collection)entry.getValue())).collect(Collectors.toList()));
        }
        for (SourceGenerator sourceGenerator : linkedHashSet2) {
            try {
                sourceGenerator.generate();
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
        return false;
    }

    private EntityType computeType(Map<TypeElement, EntityType> map, TypeElement element) {
        return map.computeIfAbsent(element, key -> new EntityType(this.processingEnv, (TypeElement)key));
    }

    private boolean isEntity(TypeElement element) {
        return Mirrors.findAnnotationMirror((Element)element, Entity.class).isPresent() || this.getOption(GENERATE_JPA, true) && Mirrors.findAnnotationMirror((Element)element, javax.persistence.Entity.class).isPresent();
    }

    private boolean isSuperclass(TypeElement element) {
        return Mirrors.findAnnotationMirror((Element)element, Superclass.class).isPresent() || this.getOption(GENERATE_JPA, true) && Mirrors.findAnnotationMirror((Element)element, MappedSuperclass.class).isPresent();
    }

    private Optional<TypeElement> typeElementOf(Element element) {
        TypeElement typeElement = null;
        switch (element.getKind()) {
            case METHOD: 
            case CONSTRUCTOR: 
            case FIELD: 
            case ENUM_CONSTANT: {
                typeElement = (TypeElement)element.getEnclosingElement();
                break;
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: {
                typeElement = (TypeElement)element;
            }
        }
        return Optional.ofNullable(typeElement);
    }

    private boolean getOption(String key, boolean defaultValue) {
        String value = this.processingEnv.getOptions().get(key);
        return value == null ? defaultValue : Boolean.valueOf(value);
    }

    private String findModelPackageName(EntityGraph graph) {
        String packageName = "";
        Set packageNames = graph.entities().stream().map(entity -> entity.typeName().packageName()).collect(Collectors.toSet());
        if (packageNames.size() == 1) {
            packageName = (String)packageNames.iterator().next();
        } else {
            String target = (String)packageNames.iterator().next();
            while (target.indexOf(".") != target.lastIndexOf(".")) {
                target = target.substring(0, target.lastIndexOf("."));
                boolean allTypesInPackage = true;
                for (EntityDescriptor entity2 : graph.entities()) {
                    if (entity2.typeName().packageName().startsWith(target)) continue;
                    allTypesInPackage = false;
                }
                if (!allTypesInPackage) continue;
                packageName = target;
                break;
            }
            if ("".equals(packageName)) {
                packageName = target;
            }
        }
        return packageName;
    }
}

