/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.processor.AttributeDescriptor;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.Mirrors;
import io.requery.processor.Names;
import io.requery.processor.QualifiedName;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

class EntityGraph {
    private final Map<TypeElement, EntityDescriptor> entities;
    private final Types types;

    EntityGraph(Types types) {
        this.types = types;
        this.entities = new HashMap<TypeElement, EntityDescriptor>();
    }

    Collection<EntityDescriptor> entities() {
        return Collections.unmodifiableCollection(this.entities.values());
    }

    public void add(EntityDescriptor entity) {
        this.entities.putIfAbsent(entity.element(), entity);
    }

    private Optional<EntityDescriptor> entityByName(QualifiedName name) {
        boolean ignorePackage = Names.isEmpty(name.packageName());
        for (EntityDescriptor entity : this.entities.values()) {
            QualifiedName entityName = entity.typeName();
            if ((!ignorePackage || !entityName.className().equals(name.className())) && !entityName.equals(name) && !EntityGraph.match(entity, name.className())) continue;
            return Optional.of(entity);
        }
        return Optional.empty();
    }

    Optional<EntityDescriptor> referencingEntity(AttributeDescriptor attribute) {
        if (!Names.isEmpty(attribute.referencedTable())) {
            return this.entities.values().stream().filter(entity -> entity.tableName().equalsIgnoreCase(attribute.referencedTable())).findFirst();
        }
        if (!Names.isEmpty(attribute.referencedType())) {
            Optional<TypeKind> primitiveType = Stream.of(TypeKind.values()).filter(TypeKind::isPrimitive).filter(kind -> kind.toString().toLowerCase().equals(attribute.referencedType())).findFirst();
            if (primitiveType.isPresent()) {
                return Optional.empty();
            }
            QualifiedName referencedType = new QualifiedName(attribute.referencedType());
            return this.entityByName(referencedType);
        }
        TypeMirror referencedType = attribute.typeMirror();
        if (attribute.isIterable()) {
            referencedType = EntityGraph.collectionElementType(referencedType);
        }
        TypeElement referencedElement = (TypeElement)this.types.asElement(referencedType);
        String referencedName = referencedElement.getSimpleName().toString();
        return this.entities.values().stream().filter(entity -> EntityGraph.match(entity, referencedName)).findFirst();
    }

    private static boolean match(EntityDescriptor entity, String referenceName) {
        return entity.typeName().className().equals(referenceName) || entity.element().getSimpleName().toString().equals(referenceName);
    }

    Optional<? extends AttributeDescriptor> referencingAttribute(AttributeDescriptor attribute, EntityDescriptor referenced) {
        String referencedColumn = attribute.referencedColumn();
        if (Names.isEmpty(referencedColumn)) {
            List keys = referenced.attributes().values().stream().filter(AttributeDescriptor::isKey).collect(Collectors.toList());
            if (keys.size() == 1) {
                return Optional.of(keys.get(0));
            }
            return keys.stream().filter(other -> other.typeMirror().equals(attribute.typeMirror())).findFirst();
        }
        return referenced.attributes().values().stream().filter(other -> other.name().equals(referencedColumn)).findFirst();
    }

    Set<AttributeDescriptor> mappedAttributes(EntityDescriptor entity, AttributeDescriptor attribute, EntityDescriptor referenced) {
        String mappedBy = attribute.mappedBy();
        if (Names.isEmpty(mappedBy)) {
            return referenced.attributes().values().stream().filter(other -> other.cardinality() != null).filter(other -> this.referencingEntity((AttributeDescriptor)other).isPresent()).filter(other -> this.referencingEntity((AttributeDescriptor)other).orElseThrow(IllegalStateException::new) == entity).collect(Collectors.toSet());
        }
        return referenced.attributes().values().stream().filter(other -> other.name().equals(mappedBy)).collect(Collectors.toSet());
    }

    private static TypeMirror collectionElementType(TypeMirror typeMirror) {
        List<TypeMirror> arguments = Mirrors.listGenericTypeArguments(typeMirror);
        return arguments.isEmpty() ? typeMirror : arguments.get(0);
    }
}

