/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.CascadeAction;
import io.requery.Persistable;
import io.requery.PropertyNameStyle;
import io.requery.ReferentialAction;
import io.requery.com.squareup.javapoet.ClassName;
import io.requery.com.squareup.javapoet.CodeBlock;
import io.requery.com.squareup.javapoet.FieldSpec;
import io.requery.com.squareup.javapoet.MethodSpec;
import io.requery.com.squareup.javapoet.ParameterSpec;
import io.requery.com.squareup.javapoet.ParameterizedTypeName;
import io.requery.com.squareup.javapoet.TypeName;
import io.requery.com.squareup.javapoet.TypeSpec;
import io.requery.meta.Attribute;
import io.requery.meta.Cardinality;
import io.requery.meta.QueryAttribute;
import io.requery.meta.QueryExpression;
import io.requery.meta.TypeBuilder;
import io.requery.processor.AndroidObservableExtension;
import io.requery.processor.AndroidParcelableExtension;
import io.requery.processor.AssociativeEntityDescriptor;
import io.requery.processor.AttributeDescriptor;
import io.requery.processor.CodeGeneration;
import io.requery.processor.EntityDescriptor;
import io.requery.processor.EntityGraph;
import io.requery.processor.EntityNameResolver;
import io.requery.processor.GeneratedProperty;
import io.requery.processor.JoinEntityGenerator;
import io.requery.processor.ListenerDescriptor;
import io.requery.processor.Mirrors;
import io.requery.processor.Names;
import io.requery.processor.PropertyGenerationExtension;
import io.requery.processor.SourceGenerator;
import io.requery.processor.TypeGenerationExtension;
import io.requery.proxy.BooleanProperty;
import io.requery.proxy.ByteProperty;
import io.requery.proxy.DoubleProperty;
import io.requery.proxy.EntityProxy;
import io.requery.proxy.FloatProperty;
import io.requery.proxy.IntProperty;
import io.requery.proxy.LongProperty;
import io.requery.proxy.PreInsertListener;
import io.requery.proxy.Property;
import io.requery.proxy.PropertyState;
import io.requery.proxy.ShortProperty;
import io.requery.query.Order;
import io.requery.util.function.Function;
import io.requery.util.function.Supplier;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

class EntityGenerator
implements SourceGenerator {
    private static final String PROXY_NAME = "$proxy";
    static final String TYPE_NAME = "$TYPE";
    private final ProcessingEnvironment processingEnvironment;
    private final Elements elements;
    private final Types types;
    private final EntityDescriptor entity;
    private final HashSet<String> attributeNames;
    private final HashSet<String> expressionNames;
    private final TypeElement typeElement;
    private final ClassName typeName;
    private final EntityGraph graph;
    private final EntityNameResolver nameResolver;
    private final Set<TypeGenerationExtension> typeExtensions;
    private final Set<PropertyGenerationExtension> memberExtensions;

    EntityGenerator(ProcessingEnvironment processingEnvironment, EntityGraph graph, EntityDescriptor entity) {
        this.entity = entity;
        this.processingEnvironment = processingEnvironment;
        this.elements = processingEnvironment.getElementUtils();
        this.types = processingEnvironment.getTypeUtils();
        this.graph = graph;
        this.nameResolver = new EntityNameResolver(graph);
        this.attributeNames = new HashSet();
        this.expressionNames = new HashSet();
        this.typeElement = entity.element();
        this.typeName = (ClassName)this.nameResolver.typeNameOf(entity);
        this.typeExtensions = new HashSet<TypeGenerationExtension>();
        this.memberExtensions = new HashSet<PropertyGenerationExtension>();
        this.typeExtensions.add(new AndroidParcelableExtension(this.types));
        AndroidObservableExtension observable = new AndroidObservableExtension(entity, processingEnvironment);
        this.typeExtensions.add(observable);
        this.memberExtensions.add(observable);
    }

    @Override
    public void generate() throws IOException {
        boolean metadataOnly;
        TypeSpec.Builder builder = TypeSpec.classBuilder(this.typeName).addModifiers(Modifier.PUBLIC).addOriginatingElement(this.typeElement);
        boolean bl = metadataOnly = this.entity.isImmutable() || this.entity.isUnimplementable();
        if (this.typeElement.getKind().isInterface()) {
            builder.addSuperinterface(ClassName.get(this.typeElement));
            builder.addSuperinterface(ClassName.get(Persistable.class));
        } else if (!metadataOnly) {
            builder.superclass(ClassName.get(this.typeElement));
            builder.addSuperinterface(ClassName.get(Persistable.class));
        }
        CodeGeneration.addGeneratedAnnotation(this.processingEnvironment, builder);
        this.generateStaticMetadata(builder, metadataOnly);
        if (!metadataOnly) {
            this.generateConstructors(builder);
            this.generateMembers(builder);
            this.generateProxyMethods(builder);
            this.generateEquals(builder);
            this.generateHashCode(builder);
            this.generateToString(builder);
        } else {
            builder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
            this.generateMembers(builder);
            this.generateImmutableTypeBuildMethod(builder);
        }
        for (TypeGenerationExtension typePart : this.typeExtensions) {
            typePart.generate(this.entity, builder);
        }
        CodeGeneration.writeType(this.processingEnvironment, this.typeName.packageName(), builder.build());
    }

    private void generateMembers(TypeSpec.Builder typeBuilder) {
        boolean generateMembers;
        if (!this.entity.isStateless()) {
            for (Map.Entry<Element, ? extends AttributeDescriptor> entry : this.entity.attributes().entrySet()) {
                AttributeDescriptor attribute = entry.getValue();
                ClassName stateType = ClassName.get(PropertyState.class);
                FieldSpec field = FieldSpec.builder(stateType, this.propertyStateFieldName(attribute), Modifier.PRIVATE).build();
                typeBuilder.addField(field);
            }
        }
        boolean bl = generateMembers = this.typeElement.getKind().isInterface() || this.entity.isImmutable() && !this.entity.builderType().isPresent();
        if (generateMembers) {
            for (Map.Entry<Element, ? extends AttributeDescriptor> entry : this.entity.attributes().entrySet()) {
                TypeName fieldTypeName;
                Element element = entry.getKey();
                AttributeDescriptor attribute = entry.getValue();
                if (element.getKind() != ElementKind.METHOD) continue;
                ExecutableElement methodElement = (ExecutableElement)element;
                TypeMirror typeMirror = methodElement.getReturnType();
                if (attribute.isIterable()) {
                    fieldTypeName = this.parameterizedCollectionName(typeMirror);
                } else if (attribute.isOptional()) {
                    typeMirror = EntityGenerator.tryFirstTypeArgument(attribute.typeMirror());
                    fieldTypeName = TypeName.get(typeMirror);
                } else {
                    fieldTypeName = this.nameResolver.tryGeneratedTypeName(typeMirror);
                }
                FieldSpec field = FieldSpec.builder(fieldTypeName, attribute.fieldName(), Modifier.PRIVATE).build();
                typeBuilder.addField(field);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void generateConstructors(TypeSpec.Builder typeBuilder) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(this.typeElement.getEnclosedElements())) {
            List<? extends VariableElement> parameters = constructor.getParameters();
            if (parameters.isEmpty()) continue;
            MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder();
            constructorBuilder.addModifiers(constructor.getModifiers());
            ArrayList<String> parameterNames = new ArrayList<String>();
            for (VariableElement variableElement : parameters) {
                Modifier[] modifiers = variableElement.getModifiers().toArray(new Modifier[variableElement.getModifiers().size()]);
                String parameterName = variableElement.getSimpleName().toString();
                parameterNames.add(parameterName);
                ParameterSpec.Builder parameterBuilder = ParameterSpec.builder(TypeName.get(variableElement.asType()), parameterName, modifiers);
                constructorBuilder.addParameter(parameterBuilder.build());
            }
            StringBuilder superParameters = new StringBuilder();
            boolean bl = false;
            for (String parameterName : parameterNames) {
                void var8_8;
                if (var8_8 > 0) {
                    superParameters.append(",");
                }
                superParameters.append(parameterName);
                ++var8_8;
            }
            constructorBuilder.addStatement("super(" + superParameters.toString() + ")", new Object[0]);
            typeBuilder.addMethod(constructorBuilder.build());
        }
    }

    private void generateProxyMethods(TypeSpec.Builder typeBuilder) {
        ParameterizedTypeName proxyName = EntityGenerator.parameterizedTypeName(EntityProxy.class, this.typeName);
        FieldSpec.Builder proxyField = FieldSpec.builder(proxyName, PROXY_NAME, Modifier.PRIVATE, Modifier.FINAL, Modifier.TRANSIENT);
        proxyField.initializer("new $T(this, $L)", proxyName, TYPE_NAME);
        typeBuilder.addField(proxyField.build());
        for (Map.Entry<Element, ? extends AttributeDescriptor> entry : this.entity.attributes().entrySet()) {
            boolean readOnly;
            AttributeDescriptor attribute = entry.getValue();
            boolean isTransient = attribute.isTransient();
            TypeMirror typeMirror = attribute.typeMirror();
            TypeName unboxedTypeName = attribute.isIterable() ? this.parameterizedCollectionName(typeMirror) : (attribute.isOptional() ? TypeName.get(EntityGenerator.tryFirstTypeArgument(attribute.typeMirror())) : this.nameResolver.tryGeneratedTypeName(typeMirror));
            String attributeName = attribute.fieldName();
            String getterName = entry.getValue().getterName();
            String fieldName = Names.upperCaseUnderscore(Names.removeMemberPrefixes(attributeName));
            MethodSpec.Builder getter = MethodSpec.methodBuilder(getterName).addModifiers(Modifier.PUBLIC).returns(attribute.isOptional() ? TypeName.get(attribute.typeMirror()) : unboxedTypeName);
            if (Mirrors.overridesMethod(this.types, this.typeElement, getterName)) {
                getter.addAnnotation(Override.class);
            }
            for (PropertyGenerationExtension snippet : this.memberExtensions) {
                snippet.addToGetter(attribute, getter);
            }
            if (isTransient) {
                getter.addStatement("return this.$L", attributeName);
            } else if (attribute.isOptional()) {
                getter.addStatement("return $T.ofNullable($L.get($L))", Optional.class, PROXY_NAME, fieldName);
            } else {
                getter.addStatement("return $L.get($L)", PROXY_NAME, fieldName);
            }
            typeBuilder.addMethod(getter.build());
            String setterName = entry.getValue().setterName();
            boolean bl = readOnly = this.entity.isReadOnly() || attribute.isReadOnly();
            if (this.entity.element().getKind().isInterface() && ElementFilter.methodsIn(this.entity.element().getEnclosedElements()).stream().anyMatch(element -> element.getSimpleName().toString().equals(setterName))) {
                readOnly = false;
            }
            if (readOnly) continue;
            String paramName = Names.lowerCaseFirst(Names.removeMemberPrefixes(attributeName));
            MethodSpec.Builder setter = MethodSpec.methodBuilder(setterName).addModifiers(Modifier.PUBLIC).addParameter(unboxedTypeName, paramName, new Modifier[0]);
            if (isTransient) {
                setter.addStatement("this.$L = $L", attributeName, paramName);
            } else {
                setter.addStatement("$L.set($L, $L)", PROXY_NAME, fieldName, paramName);
            }
            for (PropertyGenerationExtension snippet : this.memberExtensions) {
                snippet.addToSetter(attribute, setter);
            }
            PropertyNameStyle style = this.entity.propertyNameStyle();
            if (style == PropertyNameStyle.FLUENT || style == PropertyNameStyle.FLUENT_BEAN) {
                setter.addStatement("return this", new Object[0]);
                setter.returns(this.typeName);
            }
            typeBuilder.addMethod(setter.build());
        }
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC);
        this.generateListeners(constructor);
        typeBuilder.addMethod(constructor.build());
    }

    private void generateEquals(TypeSpec.Builder typeBuilder) {
        boolean overridesEquals = Mirrors.overridesMethod(this.types, this.typeElement, "equals");
        if (!overridesEquals) {
            MethodSpec.Builder equals = CodeGeneration.overridePublicMethod("equals").addParameter(TypeName.OBJECT, "obj", new Modifier[0]).returns(TypeName.BOOLEAN).addStatement("return obj instanceof $T && (($T)obj).$L.equals(this.$L)", this.typeName, this.typeName, PROXY_NAME, PROXY_NAME);
            typeBuilder.addMethod(equals.build());
        }
    }

    private void generateHashCode(TypeSpec.Builder typeBuilder) {
        if (!Mirrors.overridesMethod(this.types, this.typeElement, "hashCode")) {
            MethodSpec.Builder hashCode = CodeGeneration.overridePublicMethod("hashCode").returns(TypeName.INT).addStatement("return $L.hashCode()", PROXY_NAME);
            typeBuilder.addMethod(hashCode.build());
        }
    }

    private void generateToString(TypeSpec.Builder typeBuilder) {
        if (!Mirrors.overridesMethod(this.types, this.typeElement, "toString")) {
            MethodSpec.Builder equals = CodeGeneration.overridePublicMethod("toString").returns((Type)((Object)String.class)).addStatement("return $L.toString()", PROXY_NAME);
            typeBuilder.addMethod(equals.build());
        }
    }

    private void generateListeners(MethodSpec.Builder constructor) {
        for (Map.Entry<Element, ? extends ListenerDescriptor> entry : this.entity.listeners().entrySet()) {
            for (Annotation annotation : entry.getValue().listenerAnnotations()) {
                String annotationName = annotation.annotationType().getSimpleName();
                annotationName = annotationName.replace("Persist", "Insert").replace("Remove", "Delete");
                String methodName = Names.lowerCaseFirst(annotationName);
                TypeElement listener = this.elements.getTypeElement(PreInsertListener.class.getCanonicalName());
                PackageElement packageElement = this.elements.getPackageOf(listener);
                String packageName = packageElement.getQualifiedName().toString();
                ClassName listenerName = ClassName.get(packageName, annotationName + "Listener", new String[0]);
                ParameterizedTypeName getterType = ParameterizedTypeName.get(listenerName, this.typeName);
                TypeSpec.Builder listenerBuilder = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(getterType).addMethod(CodeGeneration.overridePublicMethod(methodName).addParameter(this.typeName, "entity", new Modifier[0]).addStatement("$L()", entry.getKey().getSimpleName()).build());
                constructor.addStatement("$L.modifyListeners().add$L($L)", PROXY_NAME, annotationName + "Listener", listenerBuilder.build());
            }
        }
    }

    private void generateType(TypeSpec.Builder typeSpecBuilder, TypeName targetName) {
        ClassName schemaName = ClassName.get(TypeBuilder.class);
        ParameterizedTypeName type = EntityGenerator.parameterizedTypeName(io.requery.meta.Type.class, targetName);
        FieldSpec.Builder schemaFieldBuilder = FieldSpec.builder(type, TYPE_NAME, Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL);
        CodeBlock.Builder typeBuilder = CodeBlock.builder().add("new $T<$T>($T.class, $S)\n", schemaName, targetName, targetName, this.entity.tableName());
        typeBuilder.add(".setBaseType($T.class)\n", ClassName.get(this.typeElement)).add(".setCacheable($L)\n", this.entity.isCacheable()).add(".setImmutable($L)\n", this.entity.isImmutable()).add(".setReadOnly($L)\n", this.entity.isReadOnly()).add(".setStateless($L)\n", this.entity.isStateless());
        String factoryName = this.entity.classFactoryName();
        if (!Names.isEmpty(factoryName)) {
            typeBuilder.add(".setFactory(new $L())\n", ClassName.bestGuess(factoryName));
        } else if (this.entity.isImmutable()) {
            TypeName builderName = this.entity.builderType().map(element -> TypeName.get(element.asType())).orElse(this.typeName);
            TypeSpec.Builder typeFactory = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(EntityGenerator.parameterizedTypeName(Supplier.class, builderName));
            MethodSpec.Builder buildMethod = CodeGeneration.overridePublicMethod("get").returns(builderName);
            if (this.entity.builderFactoryMethod().isPresent()) {
                buildMethod.addStatement("return $T.$L()", targetName, this.entity.builderFactoryMethod().map(method -> method.getSimpleName().toString()).orElse(""));
            } else {
                buildMethod.addStatement("return new $T()", builderName);
            }
            typeFactory.addMethod(buildMethod.build());
            typeBuilder.add(".setBuilderFactory($L)\n", typeFactory.build());
            TypeSpec.Builder buildFunction = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(EntityGenerator.parameterizedTypeName(Function.class, builderName, targetName)).addMethod(CodeGeneration.overridePublicMethod("apply").addParameter(builderName, "value", new Modifier[0]).addStatement("return value.build()", new Object[0]).returns(targetName).build());
            typeBuilder.add(".setBuilderFunction($L)\n", buildFunction.build());
        } else {
            TypeSpec.Builder typeFactory = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(EntityGenerator.parameterizedTypeName(Supplier.class, targetName)).addMethod(CodeGeneration.overridePublicMethod("get").addStatement("return new $T()", targetName).returns(targetName).build());
            typeBuilder.add(".setFactory($L)\n", typeFactory.build());
        }
        ParameterizedTypeName proxyType = EntityGenerator.parameterizedTypeName(EntityProxy.class, targetName);
        TypeSpec.Builder proxyProvider = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(EntityGenerator.parameterizedTypeName(Function.class, targetName, proxyType));
        MethodSpec.Builder proxyFunction = CodeGeneration.overridePublicMethod("apply").addParameter(targetName, "entity", new Modifier[0]).returns(proxyType);
        if (this.entity.isImmutable() || this.entity.isUnimplementable()) {
            proxyFunction.addStatement("return new $T(entity, $L)", proxyType, TYPE_NAME);
        } else {
            proxyFunction.addStatement("return entity.$L", PROXY_NAME);
        }
        proxyProvider.addMethod(proxyFunction.build());
        typeBuilder.add(".setProxyProvider($L)\n", proxyProvider.build());
        if (this.entity.tableAttributes() != null && this.entity.tableAttributes().length > 0) {
            StringJoiner joiner = new StringJoiner(",", "new String[] {", "}");
            for (String attribute : this.entity.tableAttributes()) {
                joiner.add("\"" + attribute + "\"");
            }
            typeBuilder.add(".setTableCreateAttributes($L)\n", joiner.toString());
        }
        this.attributeNames.forEach(name -> typeBuilder.add(".addAttribute($L)\n", name));
        this.expressionNames.forEach(name -> typeBuilder.add(".addExpression($L)\n", name));
        typeBuilder.add(".build()", new Object[0]);
        schemaFieldBuilder.initializer("$L", typeBuilder.build());
        typeSpecBuilder.addField(schemaFieldBuilder.build());
    }

    private void generateImmutableTypeBuildMethod(TypeSpec.Builder builder) {
        if (this.entity.isImmutable() && !this.entity.builderType().isPresent() && this.entity.factoryMethod().isPresent()) {
            String methodName = this.entity.factoryMethod().map(element -> element.getSimpleName().toString()).orElse("");
            List<String> argumentNames = this.entity.factoryArguments();
            StringJoiner joiner = new StringJoiner(",");
            argumentNames.forEach(name -> joiner.add("$L"));
            MethodSpec.Builder build = MethodSpec.methodBuilder("build").returns(ClassName.get(this.entity.element()));
            if (methodName.equals("<init>")) {
                Object[] args = new Object[1 + argumentNames.size()];
                args[0] = ClassName.get(this.entity.element());
                System.arraycopy(argumentNames.toArray(), 0, args, 1, argumentNames.size());
                build.addStatement("return new $T(" + joiner.toString() + ")", args).build();
            } else {
                Object[] args = new Object[2 + argumentNames.size()];
                args[0] = ClassName.get(this.entity.element());
                args[1] = methodName;
                System.arraycopy(argumentNames.toArray(), 0, args, 2, argumentNames.size());
                build.addStatement("return $T.$L(" + joiner.toString() + ")", args).build();
            }
            builder.addMethod(build.build());
        }
    }

    private void generateStaticMetadata(TypeSpec.Builder typeBuilder, boolean metadataOnly) {
        ClassName targetName = metadataOnly ? ClassName.get(this.entity.element()) : this.typeName;
        for (Map.Entry<Element, ? extends AttributeDescriptor> entry : this.entity.attributes().entrySet()) {
            AttributeDescriptor attribute = entry.getValue();
            if (attribute.isTransient()) continue;
            String fieldName = Names.upperCaseUnderscore(Names.removeMemberPrefixes(attribute.fieldName()));
            if (attribute.isForeignKey() && attribute.cardinality() != null) {
                this.graph.referencingEntity(attribute).flatMap(entity -> this.graph.referencingAttribute(attribute, (EntityDescriptor)entity)).ifPresent(foreignKey -> {
                    String name = fieldName + "_ID";
                    TypeMirror mirror = foreignKey.typeMirror();
                    FieldSpec field = this.generateAttribute(attribute, targetName, name, mirror, true);
                    typeBuilder.addField(field);
                    this.expressionNames.add(name);
                });
            }
            TypeMirror mirror = attribute.typeMirror();
            FieldSpec field = this.generateAttribute(attribute, targetName, fieldName, mirror, false);
            typeBuilder.addField(field);
            this.attributeNames.add(fieldName);
        }
        this.generateType(typeBuilder, targetName);
    }

    private FieldSpec generateAttribute(AttributeDescriptor attribute, TypeName targetName, String fieldName, TypeMirror mirror, boolean expression) {
        StringJoiner joiner;
        ParameterizedTypeName type;
        TypeName typeName;
        TypeMirror typeMirror = mirror;
        if (attribute.isIterable()) {
            typeMirror = EntityGenerator.tryFirstTypeArgument(typeMirror);
            typeName = this.parameterizedCollectionName(attribute.typeMirror());
        } else if (attribute.isOptional()) {
            typeMirror = EntityGenerator.tryFirstTypeArgument(typeMirror);
            typeName = TypeName.get(typeMirror);
        } else {
            typeName = this.nameResolver.generatedTypeNameOf(typeMirror).orElse(null);
        }
        if (typeName == null) {
            typeName = this.boxedTypeName(typeMirror);
        }
        if (expression) {
            type = EntityGenerator.parameterizedTypeName(QueryExpression.class, typeName);
        } else {
            boolean isQueryable = attribute.cardinality() == null || attribute.isForeignKey();
            Class attributeType = isQueryable ? QueryAttribute.class : Attribute.class;
            type = EntityGenerator.parameterizedTypeName(attributeType, targetName, typeName);
        }
        CodeBlock.Builder builder = CodeBlock.builder();
        if (attribute.isIterable()) {
            typeMirror = EntityGenerator.tryFirstTypeArgument(typeMirror);
            TypeName name2 = this.nameResolver.tryGeneratedTypeName(typeMirror);
            TypeElement collectionElement = (TypeElement)this.types.asElement(attribute.typeMirror());
            ParameterizedTypeName builderName = EntityGenerator.parameterizedTypeName(attribute.builderClass(), targetName, typeName, name2);
            builder.add("\nnew $T($S, $T.class, $T.class)\n", builderName, attribute.name(), ClassName.get(collectionElement), name2);
        } else if (attribute.isMap()) {
            List<TypeMirror> parameters = Mirrors.listGenericTypeArguments(typeMirror);
            TypeName keyName = TypeName.get(parameters.get(0));
            typeMirror = parameters.get(1);
            TypeName valueName = this.nameResolver.tryGeneratedTypeName(typeMirror);
            TypeElement valueElement = (TypeElement)this.types.asElement(attribute.typeMirror());
            ParameterizedTypeName builderName = EntityGenerator.parameterizedTypeName(attribute.builderClass(), targetName, typeName, keyName, valueName);
            builder.add("\nnew $T($S, $T.class, $T.class, $T.class)\n", builderName, attribute.name(), ClassName.get(valueElement), keyName, valueName);
        } else {
            String statement;
            ParameterizedTypeName builderName = EntityGenerator.parameterizedTypeName(attribute.builderClass(), targetName, typeName);
            TypeName classType = typeName;
            if (typeMirror.getKind().isPrimitive()) {
                classType = TypeName.get(typeMirror);
            }
            if (Mirrors.listGenericTypeArguments(typeMirror).size() > 0) {
                classType = TypeName.get(this.types.erasure(typeMirror));
                statement = "\nnew $T($S, (Class)$T.class)\n";
            } else {
                statement = "\nnew $T($S, $T.class)\n";
            }
            builder.add(statement, builderName, attribute.name(), classType);
        }
        if (!expression) {
            this.generateProperties(attribute, typeMirror, targetName, typeName, builder);
        }
        if (attribute.isKey()) {
            builder.add(".setKey(true)\n", new Object[0]);
        }
        builder.add(".setGenerated($L)\n", attribute.isGenerated());
        builder.add(".setLazy($L)\n", attribute.isLazy());
        builder.add(".setNullable($L)\n", attribute.isNullable());
        builder.add(".setUnique($L)\n", attribute.isUnique());
        if (!Names.isEmpty(attribute.defaultValue())) {
            builder.add(".setDefaultValue($S)\n", attribute.defaultValue());
        }
        if (!Names.isEmpty(attribute.collate())) {
            builder.add(".setCollate($S)\n", attribute.collate());
        }
        if (attribute.columnLength() != null) {
            builder.add(".setLength($L)\n", attribute.columnLength());
        }
        if (attribute.isVersion()) {
            builder.add(".setVersion($L)\n", attribute.isVersion());
        }
        if (attribute.converterName() != null) {
            builder.add(".setConverter(new $L())\n", attribute.converterName());
        }
        if (attribute.isForeignKey()) {
            builder.add(".setForeignKey($L)\n", attribute.isForeignKey());
            Optional<EntityDescriptor> referencedType = this.graph.referencingEntity(attribute);
            referencedType.ifPresent(referenced -> {
                builder.add(".setReferencedClass($T.class)\n", referenced.isImmutable() ? TypeName.get(referenced.element().asType()) : this.nameResolver.typeNameOf((EntityDescriptor)referenced));
                this.graph.referencingAttribute(attribute, (EntityDescriptor)referenced).ifPresent(referencedAttribute -> {
                    String name = Names.upperCaseUnderscore(referencedAttribute.fieldName());
                    TypeSpec provider = CodeGeneration.createAnonymousSupplier(ClassName.get(Attribute.class), CodeBlock.builder().addStatement("return $T.$L", this.nameResolver.typeNameOf((EntityDescriptor)referenced), name).build());
                    builder.add(".setReferencedAttribute($L)\n", provider);
                });
            });
        }
        if (attribute.isIndexed()) {
            builder.add(".setIndexed($L)\n", attribute.isIndexed());
            if (!attribute.indexNames().isEmpty()) {
                joiner = new StringJoiner(",");
                attribute.indexNames().forEach(name -> joiner.add("$S"));
                builder.add(".setIndexNames(" + joiner + ")\n", attribute.indexNames().toArray());
            }
        }
        if (attribute.deleteAction() != null) {
            builder.add(".setDeleteAction($T.$L)\n", ClassName.get(ReferentialAction.class), attribute.deleteAction());
        }
        if (attribute.updateAction() != null) {
            builder.add(".setUpdateAction($T.$L)\n", ClassName.get(ReferentialAction.class), attribute.updateAction());
        }
        if (!attribute.cascadeActions().isEmpty()) {
            joiner = new StringJoiner(",");
            attribute.cascadeActions().forEach(action -> joiner.add("$T.$L"));
            int index = 0;
            ClassName cascadeClass = ClassName.get(CascadeAction.class);
            Object[] args = new Object[attribute.cascadeActions().size() * 2];
            for (CascadeAction action2 : attribute.cascadeActions()) {
                args[index++] = cascadeClass;
                args[index++] = action2;
            }
            builder.add(".setCascadeAction(" + joiner + ")\n", args);
        }
        if (attribute.cardinality() != null) {
            builder.add(".setCardinality($T.$L)\n", ClassName.get(Cardinality.class), attribute.cardinality());
            this.graph.referencingEntity(attribute).ifPresent(referenced -> {
                Set<AttributeDescriptor> mappings = this.graph.mappedAttributes(this.entity, attribute, (EntityDescriptor)referenced);
                if (attribute.cardinality() == Cardinality.MANY_TO_MANY) {
                    this.generateJunctionType(attribute, (EntityDescriptor)referenced, mappings).ifPresent(name -> builder.add(".setReferencedClass($T.class)\n", name));
                }
                if (mappings.size() == 1) {
                    AttributeDescriptor mapped = mappings.iterator().next();
                    String staticMemberName = Names.upperCaseUnderscore(mapped.fieldName());
                    TypeSpec provider = CodeGeneration.createAnonymousSupplier(ClassName.get(Attribute.class), CodeBlock.builder().addStatement("return $T.$L", this.nameResolver.typeNameOf((EntityDescriptor)referenced), staticMemberName).build());
                    builder.add(".setMappedAttribute($L)\n", provider);
                }
                if (attribute.orderBy() != null) {
                    referenced.attributes().values().stream().filter(entry -> entry.name().equals(attribute.orderBy())).findFirst().ifPresent(orderBy -> {
                        String staticMemberName = Names.upperCaseUnderscore(orderBy.fieldName());
                        TypeSpec provider = CodeGeneration.createAnonymousSupplier(ClassName.get(Attribute.class), CodeBlock.builder().addStatement("return $T.$L", this.nameResolver.typeNameOf((EntityDescriptor)referenced), staticMemberName).build());
                        builder.add(".setOrderByAttribute($L)\n", provider);
                        builder.add(".setOrderByDirection($T.$L)\n", ClassName.get(Order.class), attribute.orderByDirection());
                    });
                }
            });
        }
        builder.add(".build()", new Object[0]);
        return FieldSpec.builder(type, fieldName, Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer("$L", builder.build()).build();
    }

    private Optional<ClassName> generateJunctionType(AttributeDescriptor attribute, EntityDescriptor referenced, Set<AttributeDescriptor> mappings) {
        ClassName joinName = null;
        Optional<AssociativeEntityDescriptor> joinEntity = attribute.associativeEntity();
        if (joinEntity.isPresent()) {
            if (!joinEntity.get().type().isPresent()) {
                this.graph.referencingEntity(attribute).ifPresent(referencing -> {
                    JoinEntityGenerator generator = new JoinEntityGenerator(this.processingEnvironment, this.nameResolver, this.entity, (EntityDescriptor)referencing, attribute);
                    try {
                        generator.generate();
                    }
                    catch (IOException e) {
                        this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, e.toString());
                        throw new RuntimeException(e);
                    }
                });
            }
            joinName = this.nameResolver.joinEntityName(joinEntity.get(), this.entity, referenced);
        } else if (mappings.size() == 1) {
            AttributeDescriptor mapped = mappings.iterator().next();
            joinName = mapped.associativeEntity().map(e -> this.nameResolver.joinEntityName((AssociativeEntityDescriptor)e, referenced, this.entity)).orElse(null);
        }
        return Optional.ofNullable(joinName);
    }

    private void generateProperties(AttributeDescriptor attribute, TypeMirror typeMirror, TypeName targetName, TypeName attributeName, CodeBlock.Builder builder) {
        Class propertyClass = this.propertyClassFor(typeMirror);
        ParameterizedTypeName propertyType = EntityGenerator.propertyName(propertyClass, targetName, attributeName);
        TypeSpec.Builder propertyBuilder = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(propertyType);
        boolean isNullable = typeMirror.getKind().isPrimitive() && attribute.isNullable();
        boolean useGetter = this.entity.isUnimplementable() || this.entity.isImmutable();
        boolean useSetter = this.entity.isUnimplementable();
        String getName = useGetter ? attribute.getterName() : attribute.fieldName();
        String setName = useSetter ? attribute.setterName() : attribute.fieldName();
        new GeneratedProperty(getName, setName, targetName, attributeName).setNullable(isNullable).setReadOnly(this.entity.isImmutable()).setUseMethod(useGetter).build(propertyBuilder);
        if (propertyClass != Property.class) {
            TypeName primitiveType = TypeName.get(attribute.typeMirror());
            String name = Names.upperCaseFirst(attribute.typeMirror().toString());
            new GeneratedProperty(getName, setName, targetName, primitiveType).setSuffix(name).setReadOnly(this.entity.isImmutable()).setUseMethod(useGetter).build(propertyBuilder);
        }
        builder.add(".setProperty($L)\n", propertyBuilder.build());
        if (!this.entity.isStateless()) {
            ClassName stateClass = ClassName.get(PropertyState.class);
            TypeSpec.Builder stateType = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(EntityGenerator.parameterizedTypeName(Property.class, targetName, stateClass));
            String fieldName = this.propertyStateFieldName(attribute);
            new GeneratedProperty(fieldName, targetName, stateClass).build(stateType);
            builder.add(".setPropertyState($L)\n", stateType.build());
        }
        if (this.entity.isImmutable()) {
            String propertyName = attribute.fieldName();
            TypeName builderName = this.typeName;
            useSetter = false;
            Optional<TypeElement> builderType = this.entity.builderType();
            if (builderType.isPresent()) {
                propertyName = attribute.setterName();
                builderName = TypeName.get(builderType.get().asType());
                useSetter = true;
                for (ExecutableElement method : ElementFilter.methodsIn(builderType.get().getEnclosedElements())) {
                    List<? extends VariableElement> parameters = method.getParameters();
                    String name = Names.removeMethodPrefixes(method.getSimpleName());
                    if ((!name.startsWith("with") || name.length() <= 4 || !Character.isUpperCase(name.charAt(4))) && (!name.equalsIgnoreCase(attribute.fieldName()) || parameters.size() != 1)) continue;
                    propertyName = method.getSimpleName().toString();
                    break;
                }
            }
            propertyType = EntityGenerator.propertyName(propertyClass, builderName, attributeName);
            TypeSpec.Builder builderProperty = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(propertyType);
            new GeneratedProperty(propertyName, builderName, attributeName).setWriteOnly(true).setUseMethod(useSetter).build(builderProperty);
            if (propertyClass != Property.class) {
                TypeName primitiveType = TypeName.get(attribute.typeMirror());
                String name = Names.upperCaseFirst(attribute.typeMirror().toString());
                new GeneratedProperty(propertyName, builderName, primitiveType).setSuffix(name).setUseMethod(useSetter).setWriteOnly(true).build(builderProperty);
            }
            builder.add(".setBuilderProperty($L)\n", builderProperty.build());
        }
    }

    private static ParameterizedTypeName propertyName(Class type, TypeName targetName, TypeName fieldName) {
        return type == Property.class ? EntityGenerator.parameterizedTypeName(type, targetName, fieldName) : EntityGenerator.parameterizedTypeName(type, targetName);
    }

    private Class propertyClassFor(TypeMirror typeMirror) {
        if (typeMirror.getKind().isPrimitive()) {
            switch (typeMirror.getKind()) {
                case BOOLEAN: {
                    return BooleanProperty.class;
                }
                case BYTE: {
                    return ByteProperty.class;
                }
                case SHORT: {
                    return ShortProperty.class;
                }
                case INT: {
                    return IntProperty.class;
                }
                case LONG: {
                    return LongProperty.class;
                }
                case FLOAT: {
                    return FloatProperty.class;
                }
                case DOUBLE: {
                    return DoubleProperty.class;
                }
            }
        }
        return Property.class;
    }

    private String propertyStateFieldName(AttributeDescriptor attribute) {
        return "$" + attribute.fieldName() + "_state";
    }

    private TypeName boxedTypeName(TypeMirror typeMirror) {
        if (typeMirror.getKind().isPrimitive()) {
            return TypeName.get(this.types.boxedClass((PrimitiveType)typeMirror).asType());
        }
        return TypeName.get(typeMirror);
    }

    private ParameterizedTypeName parameterizedCollectionName(TypeMirror typeMirror) {
        TypeMirror genericType = EntityGenerator.tryFirstTypeArgument(typeMirror);
        TypeName elementName = this.nameResolver.tryGeneratedTypeName(genericType);
        TypeElement collectionElement = (TypeElement)this.types.asElement(typeMirror);
        ClassName collectionName = ClassName.get(collectionElement);
        return ParameterizedTypeName.get(collectionName, elementName);
    }

    private static TypeMirror tryFirstTypeArgument(TypeMirror typeMirror) {
        List<TypeMirror> args = Mirrors.listGenericTypeArguments(typeMirror);
        return args.isEmpty() ? typeMirror : args.get(0);
    }

    private static ParameterizedTypeName parameterizedTypeName(Class<?> rawType, TypeName ... typeArguments) {
        return ParameterizedTypeName.get(ClassName.get(rawType), typeArguments);
    }
}

