/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.com.squareup.javapoet.AnnotationSpec;
import io.requery.com.squareup.javapoet.ClassName;
import io.requery.com.squareup.javapoet.CodeBlock;
import io.requery.com.squareup.javapoet.JavaFile;
import io.requery.com.squareup.javapoet.MethodSpec;
import io.requery.com.squareup.javapoet.ParameterizedTypeName;
import io.requery.com.squareup.javapoet.TypeName;
import io.requery.com.squareup.javapoet.TypeSpec;
import io.requery.processor.EntityProcessor;
import io.requery.util.function.Supplier;
import java.io.IOException;
import javax.annotation.Generated;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.Elements;

class CodeGeneration {
    private CodeGeneration() {
    }

    static void addGeneratedAnnotation(ProcessingEnvironment processingEnvironment, TypeSpec.Builder builder) {
        Elements elements = processingEnvironment.getElementUtils();
        if (elements.getTypeElement(Generated.class.getCanonicalName()) != null) {
            builder.addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", EntityProcessor.class.getCanonicalName()).build());
        }
    }

    static TypeSpec createAnonymousSupplier(TypeName type, CodeBlock block) {
        return TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(ParameterizedTypeName.get(ClassName.get(Supplier.class), type)).addMethod(CodeGeneration.overridePublicMethod("get").addCode(block).returns(type).build()).build();
    }

    static MethodSpec.Builder overridePublicMethod(String name) {
        return MethodSpec.methodBuilder(name).addModifiers(Modifier.PUBLIC).addAnnotation(Override.class);
    }

    static void writeType(ProcessingEnvironment processingEnvironment, String packageName, TypeSpec typeSpec) throws IOException {
        JavaFile file = JavaFile.builder(packageName, typeSpec).addFileComment("Generated file do not edit, generated by " + EntityProcessor.class.getCanonicalName(), new Object[0]).indent("    ").build();
        file.writeTo(processingEnvironment.getFiler());
    }
}

