/*
 * Decompiled with CFR 0.152.
 */
package io.requery.jackson;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import io.requery.Column;
import io.requery.Table;
import io.requery.Transient;
import io.requery.View;
import io.requery.jackson.EntityStoreResolver;
import io.requery.meta.Attribute;
import io.requery.meta.EntityModel;
import io.requery.meta.Type;
import io.requery.proxy.EntityProxy;
import io.requery.proxy.PropertyState;
import java.lang.reflect.Field;

class EntityAnnotationIntrospector
extends AnnotationIntrospector {
    private final EntityModel model;
    private final Version version;
    private boolean useTableNames;

    EntityAnnotationIntrospector(EntityModel model, Version version) {
        this.model = model;
        this.version = version;
        this.useTableNames = false;
    }

    public Version version() {
        return this.version;
    }

    public ObjectIdInfo findObjectIdInfo(Annotated annotated) {
        Class rawClass = annotated.getType().getRawClass();
        for (Type type : this.model.getTypes()) {
            if (type.getClassType() != rawClass || type.getSingleKeyAttribute() == null) continue;
            Attribute attribute = type.getSingleKeyAttribute();
            String name = this.removePrefix(attribute.getPropertyName());
            if (this.useTableNames) {
                name = attribute.getName();
            }
            for (Class superClass = rawClass.getSuperclass(); superClass != Object.class && superClass != null; superClass = superClass.getSuperclass()) {
                try {
                    Field field = superClass.getDeclaredField(attribute.getPropertyName());
                    JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
                    if (jsonProperty == null) continue;
                    name = jsonProperty.value();
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            return new ObjectIdInfo(new PropertyName(name), rawClass, ObjectIdGenerators.PropertyGenerator.class, EntityStoreResolver.class);
        }
        return super.findObjectIdInfo(annotated);
    }

    private String removePrefix(String name) {
        String[] prefixes;
        for (String prefix : prefixes = new String[]{"get", "is"}) {
            if (!name.startsWith(prefix) || name.length() <= prefix.length()) continue;
            StringBuilder sb = new StringBuilder(name.substring(prefix.length()));
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            return sb.toString();
        }
        return name;
    }

    public PropertyName findNameForDeserialization(Annotated annotated) {
        if (this.useTableNames) {
            return this.getMappedName(annotated);
        }
        return super.findNameForDeserialization(annotated);
    }

    public PropertyName findNameForSerialization(Annotated annotated) {
        if (this.useTableNames) {
            return this.getMappedName(annotated);
        }
        return super.findNameForSerialization(annotated);
    }

    private PropertyName getMappedName(Annotated annotated) {
        if (annotated.hasAnnotation(Table.class)) {
            Table table = (Table)annotated.getAnnotation(Table.class);
            return new PropertyName(table.name());
        }
        if (annotated.hasAnnotation(View.class)) {
            View view = (View)annotated.getAnnotation(View.class);
            return new PropertyName(view.name());
        }
        if (annotated.hasAnnotation(Column.class)) {
            Column column = (Column)annotated.getAnnotation(Column.class);
            return new PropertyName(column.name());
        }
        return null;
    }

    public boolean hasIgnoreMarker(AnnotatedMember member) {
        return member.hasAnnotation(Transient.class);
    }

    public Boolean isIgnorableType(AnnotatedClass annotatedClass) {
        return PropertyState.class.isAssignableFrom(annotatedClass.getAnnotated()) || EntityProxy.class.isAssignableFrom(annotatedClass.getAnnotated());
    }
}

