/*
 * Decompiled with CFR 0.152.
 */
package io.requery.jackson;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import io.requery.jackson.EntityBeanDeserializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class DeserializerModifier
extends BeanDeserializerModifier {
    DeserializerModifier() {
    }

    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        if (deserializer instanceof BeanDeserializer) {
            BeanDeserializer beanDeserializer = (BeanDeserializer)deserializer;
            return new EntityBeanDeserializer((BeanDeserializerBase)beanDeserializer, deserializer.getObjectIdReader());
        }
        return super.modifyDeserializer(config, beanDesc, deserializer);
    }

    public List<BeanPropertyDefinition> updateProperties(DeserializationConfig config, BeanDescription beanDesc, List<BeanPropertyDefinition> propDefs) {
        List definitions = super.updateProperties(config, beanDesc, propDefs);
        ArrayList<BeanPropertyDefinition> remove = new ArrayList<BeanPropertyDefinition>();
        ArrayList<POJOPropertyBuilder> add = new ArrayList<POJOPropertyBuilder>();
        for (BeanPropertyDefinition definition : definitions) {
            if (!definition.hasGetter() || !Collection.class.isAssignableFrom(definition.getGetter().getRawType()) || !(definition instanceof POJOPropertyBuilder)) continue;
            POJOPropertyBuilder builder = (POJOPropertyBuilder)definition;
            builder = new POJOPropertyBuilder(builder, builder.getFullName()){

                public boolean hasField() {
                    return false;
                }
            };
            remove.add(definition);
            add.add(builder);
        }
        definitions.removeAll(remove);
        definitions.addAll(add);
        return definitions;
    }
}

