/*
 * Decompiled with CFR 0.152.
 */
package io.requery.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import java.io.IOException;

class EntityBeanDeserializer
extends BeanDeserializer {
    EntityBeanDeserializer(BeanDeserializerBase source, ObjectIdReader reader) {
        super(source, reader);
    }

    public Object deserializeFromObject(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this._nonStandardCreation || this._needViewProcesing) {
            return super.deserializeFromObject(p, ctxt);
        }
        Object bean = null;
        if (p.hasTokenId(5)) {
            String propertyName = p.getCurrentName();
            do {
                p.nextToken();
                SettableBeanProperty property = this._beanProperties.find(propertyName);
                if (property == null) {
                    this.handleUnknownVanilla(p, ctxt, bean, propertyName);
                    continue;
                }
                if (bean == null) {
                    if (propertyName.equals(this._objectIdReader.propertyName.getSimpleName())) {
                        Object id = property.deserialize(p, ctxt);
                        ReadableObjectId objectId = ctxt.findObjectId(id, this._objectIdReader.generator, this._objectIdReader.resolver);
                        Object object = bean = objectId == null ? null : objectId.resolve();
                        if (bean == null) {
                            bean = this._valueInstantiator.createUsingDefault(ctxt);
                            property.set(bean, id);
                        }
                    } else {
                        bean = this._valueInstantiator.createUsingDefault(ctxt);
                    }
                    p.setCurrentValue(bean);
                }
                property.deserializeAndSet(p, ctxt, bean);
            } while ((propertyName = p.nextFieldName()) != null);
        }
        return bean;
    }
}

