package io.relayr.java.model.action;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;

import io.relayr.java.RelayrJavaSdk;
import io.relayr.java.model.models.DeviceModel;
import io.relayr.java.model.models.transport.DeviceCommand;
import io.relayr.java.model.models.transport.DeviceConfiguration;
import rx.Observable;

/**
 * Defines command to be sent to device. Defined with {@link DeviceCommand} in
 * {@link DeviceModel}
 */
public class Command extends Action implements Serializable {

    final private String command;

    /**
     * @param path    identifies the component to which the command should be sent {@link DeviceCommand#getPath()}
     * @param command defined in device io.relayr.java.model {@link DeviceCommand#getName()}
     * @param value   type of value object is defined in device io.relayr.java.model with {@link DeviceConfiguration#getValueSchema()}
     */
    public Command(String path, String command, Object value) {
        this.path = path;
        this.value = value;
        this.command = command;
    }

    @Override public Observable<Void> send(String deviceId) {
        if (path == null) throwIfNull("Path");
        if (command == null) throwIfNull("Command");
        if (value == null) throwIfNull("Value");

        if (!mValidated) throwNotValidated();

        return RelayrJavaSdk.getRelayrApi()
                .sendCommand(deviceId, this)
                .timeout(7, TimeUnit.SECONDS);
    }

    @Override public String toString() {
        return "Command{" +
                "command='" + command + '\'' +
                "} " + super.toString();
    }
}