package io.relayr.java.model.account;

import java.io.Serializable;
import java.util.List;

import io.relayr.java.RelayrJavaSdk;
import rx.Observable;

/** Third party account that can be connected with the relayr user. */
public class Account implements Serializable {

    /** Account name for identification */
    private final String name;
    /** Account name for presentation */
    private final String readableName;
    /** Authentication URL */
    private final String oauthUrl;

    public Account(String name, String readableName, String oauthUrl) {
        this.name = name;
        this.readableName = readableName;
        this.oauthUrl = oauthUrl;
    }

    /** @return account name id */
    public String getName() {
        return name;
    }

    /** @return presentation account name */
    public String getReadableName() {
        return readableName;
    }

    /** @return oauth URL */
    public String getOauthUrl() {
        return oauthUrl;
    }

    /** @return list of available devices for the account */
    public Observable<List<AccountDevice>> getDevices() {
        return RelayrJavaSdk.getAccountsApi().getAccountDevices(name);
    }

    /** @return login URL for the account */
    public Observable<AccountUrl> getLoginUrl(String redirectUrl) {
        return RelayrJavaSdk.getAccountsApi().getLoginUrl(name, redirectUrl);
    }

    /** @return login URL for the account */
    public Observable<Void> isConnected(String userId) {
        return RelayrJavaSdk.getUserApi().isAccountConnected(userId, name);
    }
}
