package io.relayr.java.api.mock;

import com.google.gson.reflect.TypeToken;

import java.util.List;

import javax.inject.Inject;

import io.relayr.java.api.RelayrApi;
import io.relayr.java.model.action.Command;
import io.relayr.java.model.action.Configuration;
import io.relayr.java.model.CreateDevice;
import io.relayr.java.model.Device;
import io.relayr.java.model.Transmitter;
import io.relayr.java.model.TransmitterDevice;
import io.relayr.java.model.onboarding.OnBoardingState;
import retrofit.client.Response;
import rx.Observable;
import rx.Subscriber;

public class MockRelayrApi implements RelayrApi {

    private final MockBackend mMockBackend;

    @Inject public MockRelayrApi(MockBackend mockBackend) {
        mMockBackend = mockBackend;
    }

    @Override
    public Observable<Void> sendCommand(String deviceId, Command command) {
        return Observable.create(new Observable.OnSubscribe<Void>() {
            @Override
            public void call(Subscriber<? super Void> subscriber) {
                subscriber.onNext(null);
            }
        });
    }

    @Override
    public Observable<Void> deleteDevice(String deviceId) {
        return Observable.create(new Observable.OnSubscribe<Void>() {
            @Override
            public void call(Subscriber<? super Void> subscriber) {
                subscriber.onNext(null);
            }
        });
    }

    @Override
    public Observable<Device> updateDevice(Device device, String deviceId) {
        return Observable.just(device);
    }

    @Override
    public Observable<Transmitter> getTransmitter(String transmitter) {
        return mMockBackend.createObservable(new TypeToken<Transmitter>() {
        }, MockBackend.USERS_TRANSMITTER);
    }

    @Override
    public Observable<Transmitter> updateTransmitter(Transmitter transmitter, String id) {
        return Observable.just(transmitter);
    }

    @Override
    public Observable<List<TransmitterDevice>> getTransmitterDevices(String transmitter) {
        return mMockBackend.createObservable(new TypeToken<List<TransmitterDevice>>() { },
                MockBackend.TRANSMITTER_DEVICES);
    }

    @Override
    public Observable<Transmitter> registerTransmitter(Transmitter transmitter) {
        return Observable.just(transmitter);
    }

    @Override
    public Observable<List<Device>> getPublicDevices(String meaning) {
        return mMockBackend.createObservable(new TypeToken<List<Device>>() {
        }, MockBackend.PUBLIC_DEVICES);
    }

    @Override
    public Observable<Void> deleteWunderBar(String transmitterId) {
        return Observable.create(new Observable.OnSubscribe<Void>() {
            @Override
            public void call(Subscriber<? super Void> subscriber) {
                subscriber.onNext(null);
            }
        });
    }

    @Override
    public Observable<Configuration> getDeviceConfiguration(String deviceId, String path) {
        return Observable.empty();
    }

    @Override
    public Observable<Void> setDeviceConfiguration(String deviceId, Configuration configuration) {
        return Observable.empty();
    }

    @Override
    public Observable<Void> deleteTransmitter(String transmitterId) {
        return Observable.create(new Observable.OnSubscribe<Void>() {
            @Override
            public void call(Subscriber<? super Void> subscriber) {
                subscriber.onNext(null);
            }
        });
    }

    @Override
    public Observable<OnBoardingState> isTransmitterConnected(String transmitterId) {
        return Observable.empty();
    }

    @Override
    public Observable<OnBoardingState> isDeviceConnected(String deviceId) {
        return Observable.empty();
    }

    @Override
    public Observable<Response> scanForDevices(String transmitterId, int period) {
        return Observable.empty();
    }

    @Override
    public Observable<Device> createDevice(CreateDevice device) {
        return mMockBackend.createObservable(new TypeToken<Device>() { },
                MockBackend.USER_DEVICE);
    }
}
