package io.relayr.java.api;

import io.relayr.java.model.models.DeviceFirmware;
import io.relayr.java.model.models.DeviceFirmwares;
import io.relayr.java.model.models.DeviceModels;
import io.relayr.java.model.models.ReadingMeanings;
import io.relayr.java.model.models.DeviceModel;
import retrofit.http.GET;
import retrofit.http.Path;
import retrofit.http.Query;
import rx.Observable;

public interface DeviceModelsApi {

    /**
     * Returns a list of the possible reading types of the devices on the relayr platform
     * @return an {@link Observable} with a list of Reading meanings
     */
    @GET("/device-models/meanings") Observable<ReadingMeanings> getReadingMeanings();

    /**
     * Returns list all available device models.
     * @param limit maximum number of device models to fetch
     * @return an {@link Observable} with a list of device models.
     */
    @GET("/device-models") Observable<DeviceModels> getDeviceModels(@Query("limit") int limit);

    /**
     * Returns list all available device models.
     * @param limit  maximum number of device models to fetch
     * @param offset offset from zero index
     * @return an {@link Observable} with a list of device models.
     */
    @GET("/device-models")
    Observable<DeviceModels> getDeviceModels(@Query("limit") int limit, @Query("offset") int offset);

    /**
     * Returns specific device io.relayr.java.model
     * @return an {@link Observable}
     */
    @GET("/device-models/{modelId}") Observable<DeviceModel> getDeviceModelById(
            @Path("modelId") String modelId);

    /**
     * Returns specific device io.relayr.java.model's firmware list
     * @return an {@link Observable}
     */
    @GET("/device-models/{modelId}/firmware") Observable<DeviceFirmwares> getDeviceModelFirmwares(
            @Path("modelId") String modelId);

    /**
     * Returns device io.relayr.java.model defined by modelId and firmware version
     * @return an {@link Observable}
     */
    @GET("/device-models/{modelId}/firmware/{version}")
    Observable<DeviceFirmware> getDeviceModelByFirmware(
            @Path("modelId") String modelId, @Path("version") String version);

    /**
     * Returns list of all device models owned by user
     * @return an {@link Observable} with a list of device models.
     */
    @GET("/users/{userId}/device-models") Observable<DeviceModels> getUsersDeviceModels(
            @Path("userId") String userId);

    /**
     * Returns list of all device models owned by user
     * @return an {@link Observable} with a list of device models.
     */
    @GET("/users/{userId}/device-models/{modelId}") Observable<DeviceModel> getUsersDeviceModelById(
            @Path("userId") String userId, @Path("modelId") String modelId);

    /**
     * Returns specific device io.relayr.java.model's firmware list
     * @return an {@link Observable}
     */
    @GET("/users/{userId}/device-models/{modelId}/firmware") Observable<DeviceFirmwares>
    getUsersDeviceModelFirmwares(
            @Path("userId") String userId,
            @Path("modelId") String modelId);

    /**
     * Returns device io.relayr.java.model defined by modelId and firmware version
     * @return an {@link Observable}
     */
    @GET("/users/{userId}/device-models/{modelId}/firmware/{version}") Observable<DeviceFirmware>
    getUsersDeviceModelByFirmware(@Path("userId") String userId,
                                  @Path("modelId") String modelId,
                                  @Path("version") String version);

}
