package io.relayr.java.storage;

import com.google.gson.reflect.TypeToken;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;

import javax.inject.Inject;

import io.relayr.java.api.mock.MockBackend;
import io.relayr.java.model.models.DeviceModel;
import io.relayr.java.model.models.DeviceModels;
import io.relayr.java.model.models.error.DeviceModelsException;
import rx.Subscriber;

public class MockDeviceModelCache{

    private static final Map<String, DeviceModel> sDeviceModels = new ConcurrentHashMap<String, DeviceModel>();

    private final MockBackend mMockBackend;

    @Inject
    public MockDeviceModelCache(MockBackend mockBackend) {

        mMockBackend = mockBackend;
        refresh();
    }

    public boolean isEmpty() {
       return false;
    }

    public DeviceModel getModelById(String modelId) throws DeviceModelsException {
        if (modelId == null) throw DeviceModelsException.nullModelId();

        if (isEmpty()) throw DeviceModelsException.cacheNotReady();

        DeviceModel model = sDeviceModels.get(modelId);
        if (model == null) throw DeviceModelsException.deviceModelNotFound();

        return model;
    }

    public void refresh() {
        mMockBackend.createObservable(new TypeToken<DeviceModels>() { }, MockBackend.DEVICE_MODELS)
                .subscribe(new Subscriber<DeviceModels>() {
                    @Override
                    public void onCompleted() {}

                    @Override
                    public void onError(Throwable e) {
                        e.printStackTrace();
                        if (e instanceof TimeoutException) refresh();
                    }

                    @Override
                    public void onNext(DeviceModels deviceModels) {
                        for (DeviceModel deviceModel : deviceModels.getModels())
                            sDeviceModels.put(deviceModel.getId(), deviceModel);
                    }
                });
    }
}
