package io.relayr.java.model.models.schema;

import java.util.ArrayList;
import java.util.List;

public class StringSchema extends ValueSchema {

    public StringSchema(ValueSchema schema) {
        title = schema.title;
        description = schema.description;
        unit = schema.unit;
        schemaType = schema.schemaType;

        maxLength = schema.maxLength;
        minLength = schema.minLength;
        pattern = schema.pattern;
        enums = schema.enums;
    }

    /** If defined this integer MUST be greater than, or equal to, 0. */
    public Integer getMaxLength() {
        return maxLength;
    }

    /** If defined this integer MUST be greater than, or equal to, 0. */
    public Integer getMinLength() {
        return minLength;
    }

    /** @return valid regular expression, according to the ECMA 262 regular expression dialect. */
    public String getPattern() {
        return pattern;
    }

    /** @return possible values for this field. If these are not defined String can be anything. */
    public List<String> getPossibleValues() {
        if (enums == null) return new ArrayList<>();
        return enums;
    }

    /** @return true if there are any possible values for the field. */
    public boolean hasValues() {
        return enums != null && !enums.isEmpty();
    }

    @Override public boolean validate(Object value) {
        if (!validateNull(value)) return false;
        if (!(value instanceof String)) return false;

        String stringValue = (String) value;

        if (minLength != null)
            if (stringValue.length() < minLength) return false;
        if (maxLength != null)
            if (stringValue.length() > maxLength) return false;

        if (pattern != null)
            if (!stringValue.matches(pattern)) return false;

        if (hasValues()) {
            boolean found = false;
            for (String item : getPossibleValues())
                if (stringValue.equals(item)) {
                    found = true;
                    break;
                }

            if (!found) return false;
        }

        return true;
    }
}
