package io.relayr.java.model.models.schema;

public enum SchemaType {
    OBJECT("object"),
    ARRAY("array"),
    INTEGER("integer"),
    NUMBER("number"),
    BOOLEAN("boolean"),
    STRING("string"),
    NULL("null");

    private final String type;

    SchemaType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    public static SchemaType getByType(String type) {
        for (SchemaType schemaType : values())
            if (schemaType.getType().equals(type)) return schemaType;
        return NULL;
    }
}
