package io.relayr.java.model.action;

import java.io.Serializable;

import io.relayr.java.model.models.schema.ValueSchema;
import io.relayr.java.model.models.transport.DeviceConfiguration;
import rx.Observable;
import rx.Subscriber;

public abstract class Action implements Serializable {

    protected String path;
    protected Object value;
    protected boolean mValidated;

    public boolean validate(ValueSchema schema) {
        mValidated = schema.validate(value);
        return mValidated;
    }

    protected Observable<Void> throwIfNull(final String what) {
        return Observable.create(new Observable.OnSubscribe<Void>() {
            @Override public void call(Subscriber<? super Void> subscriber) {
                subscriber.onError(new NullPointerException(what + " can not be null!"));
            }
        });
    }

    protected Observable<Void> throwNotValidated() {
        return Observable.create(new Observable.OnSubscribe<Void>() {
            @Override public void call(Subscriber<? super Void> subscriber) {
                subscriber.onError(new NullPointerException("Please validate before sending."));
            }
        });
    }

    /** Identifies the component to which the configuration should be sent. */
    public String getPath() {
        return path;
    }

    /** Get current configuration value. Type of value object is defined with {@link DeviceConfiguration#getValueSchema()} */
    public Object getValue() {
        return value;
    }

    public abstract Observable<Void> send(String deviceId);

    @Override public String toString() {
        return "Action{" +
                "path='" + path + '\'' +
                ", value=" + value +
                '}';
    }
}
