package io.relayr.java;

import dagger.ObjectGraph;

public class RelayrJavaApp {

    protected static String mToken;
    protected static RelayrJavaApp sApp;
    protected static ObjectGraph sObjectGraph;

    protected RelayrJavaApp(boolean mockMode) {
        sApp = this;
        buildObjectGraphAndInject(mockMode);
    }

    /**
     * Condition (sApp == null || mockMode) is used when Relayr app is already initialized
     * but you need to recreate it with another set of Dagger modules (e.g. while testing)
     * @param mockMode true for debug mode and tests
     */
    public static void init(String token, boolean mockMode) {
        reset();
        mToken = token;
        if (sApp == null || mockMode) {
            synchronized (new Object()) {
                if (sApp == null || mockMode) {
                    new RelayrJavaApp(mockMode);
                }
            }
        }
    }

    protected static void buildObjectGraphAndInject(boolean mockMode) {
        sObjectGraph = mockMode ? ObjectGraph.create(DebugModules.list()) :
                ObjectGraph.create(Modules.list());
        sObjectGraph.injectStatics();
        sObjectGraph.inject(sApp);
    }

    public static String getToken() {
        return mToken;
    }

    public static void setToken(String token) {
        mToken = token;
    }

    public static void inject(Object o) {
        sObjectGraph.inject(o);
    }

    protected static void reset() {
        mToken = null;
        sApp = null;
        sObjectGraph = null;
    }

}
