package io.relayr.java.model.models.schema;

import java.util.List;

import io.relayr.java.model.models.transport.DeviceReading;

public class ObjectSchema extends ValueSchema {

    public ObjectSchema(ValueSchema schema) {
        title = schema.title;
        description = schema.description;
        unit = schema.unit;
        schemaType = schema.schemaType;

        properties = schema.properties;
        maxProperties = schema.maxProperties;
        minProperties = schema.minProperties;
        required = schema.required;
        additionalProperties = schema.additionalProperties;
        patternProperties = schema.patternProperties;
        dependencies = schema.dependencies;
    }

    /** This object should be parsed depending on {@link DeviceReading#meaning} */
    public Object getProperties() {
        return properties;
    }

    /** If defined this integer MUST be greater than, or equal to, 0. */
    public int getMaxProperties() {
        return maxProperties;
    }

    /** If defined this integer MUST be greater than, or equal to, 0. */
    public int getMinProperties() {
        return minProperties;
    }

    /** @return required properties names. */
    public List<String> getRequired() {
        return required;
    }

    /** @return true if contains additional properties. */
    public boolean hasAdditionalProperties() {
        return additionalProperties != null;
    }

    /** @return additional properties if there is any, null otherwise. */
    public Object getAdditionalProperties() {
        return additionalProperties;
    }

    /**
     * @return pattern properties.
     * Each property name of this object SHOULD be a valid regular expression,
     * according to the ECMA 262 regular expression dialect.
     */
    public Object getPatternProperties() {
        return patternProperties;
    }

    public Object getDependencies() {
        return dependencies;
    }

    @Override public boolean validate(Object value) {
        return validateNull(value);
    }
}
