package io.relayr.java.model.action;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;

import io.relayr.java.RelayrJavaSdk;
import io.relayr.java.model.models.DeviceModel;
import io.relayr.java.model.models.transport.DeviceConfiguration;
import rx.Observable;

/**
 * Defines configuration parameters currently on device. Defined with {@link DeviceConfiguration}
 * in {@link DeviceModel}
 */
public class Configuration extends Action implements Serializable {

    private final String configuration;

    /**
     * @param path          identifies the component to which the configuration should be sent {@link DeviceConfiguration#getPath()}
     * @param configuration defined in device io.relayr.java.model {@link DeviceConfiguration#getName()}
     * @param value         type of value object is defined in device io.relayr.java.model with {@link DeviceConfiguration#getValueSchema()}
     */
    public Configuration(String path, String configuration, Object value) {
        this.path = path;
        this.value = value;
        this.configuration = configuration;
    }

    @Override public Observable<Void> send(String deviceId) {
        if (path == null) throwIfNull("Path");
        if (configuration == null) throwIfNull("Configuration");
        if (value == null) throwIfNull("Value");

        if (!mValidated) throwNotValidated();

        return RelayrJavaSdk.getRelayrApi()
                .setDeviceConfiguration(deviceId, this)
                .timeout(7, TimeUnit.SECONDS);
    }

    @Override public String toString() {
        return "Configuration{" +
                "configuration='" + configuration + '\'' +
                "} " + super.toString();
    }
}
