package io.relayr.java.model;

import java.io.Serializable;

/** Use to add new device to Relayr platform. For example when creating a prototype. */
public class CreateDevice implements Serializable {

    private final String name;
    private final String owner;
    private String model;
    private String firmware;
    private String externalId;
    private String transmitterId;
    private String integrationType;

    /** Default simple constructor for prototype creation */
    public CreateDevice(String name, String userId) {
        this.name = name;
        this.owner = userId;
        this.integrationType = "relayr";
    }

    /** Default constructor for prototype creation */
    public CreateDevice(String name, String modelId, String userId, String externalId, String firmware) {
        this.name = name;
        this.model = modelId;
        this.owner = userId;
        this.externalId = externalId;
        this.firmware = firmware;
        this.integrationType = "relayr";
    }

    public CreateDevice(String name, String modelId, String userId, String externalId, String firmware, String accountType) {
        this.name = name;
        this.model = modelId;
        this.owner = userId;
        this.externalId = externalId;
        this.firmware = firmware;
        this.integrationType = accountType;
    }

    public void setTransmitterId(String transmitterId) {
        this.transmitterId = transmitterId;
    }

    public void setIntegrationType(String integrationType) {
        this.integrationType = integrationType;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setFirmware(String firmware) {
        this.firmware = firmware;
    }

    public void setModel(String model) {
        this.model = model;
    }
}
