package io.relayr.java.api.mock;

import com.google.gson.reflect.TypeToken;

import java.util.List;

import javax.inject.Inject;

import io.relayr.java.model.App;
import io.relayr.java.model.Bookmark;
import io.relayr.java.model.CreateWunderBar;
import io.relayr.java.model.Device;
import io.relayr.java.model.Transmitter;
import io.relayr.java.model.User;
import io.relayr.java.model.account.Account;
import io.relayr.java.api.UserApi;
import io.relayr.java.model.BookmarkDevice;
import io.relayr.java.model.groups.Group;
import rx.Observable;
import rx.Subscriber;

public class MockUserApi implements UserApi {

    private final MockBackend mServer;

    @Inject
    public MockUserApi(MockBackend mockBackend) {
        mServer = mockBackend;
    }

    @Override
    public Observable<App> getAppInfo() {
        return mServer.createObservable(new TypeToken<App>() {
        }, MockBackend.APP_INFO);
    }

    @Override
    public Observable<User> getUserInfo() {
        return mServer.createObservable(new TypeToken<User>() {}, MockBackend.USER_INFO);
    }

    @Override
    public Observable<List<Device>> getDevices(String userId) {
        return mServer.createObservable(new TypeToken<List<Device>>() {
        }, MockBackend.USER_DEVICES);
    }

    @Override public Observable<List<Group>> getGroups(String userId) {
        return mServer.createObservable(new TypeToken<List<Group>>() {
        }, MockBackend.USER_GROUPS);
    }

    @Override public Observable<Void> deleteAllGroups(String userId) {
        return Observable.empty();
    }

    @Override
    public Observable<User> updateUserDetails(User user, String userId) {
        return Observable.just(user);
    }

    @Override
    public Observable<CreateWunderBar> createWunderBar(String userId) {
        return mServer.createObservable(new TypeToken<CreateWunderBar>() {
        }, MockBackend.USERS_CREATE_WUNDERBAR);
    }

    @Override
    public Observable<List<Transmitter>> getTransmitters(String userId) {
        return mServer.createObservable(new TypeToken<List<Transmitter>>() {
        }, MockBackend.USERS_TRANSMITTERS);
    }

    @Override
    public Observable<Bookmark> bookmarkPublicDevice(String userId, String deviceId) {
        return mServer.createObservable(new TypeToken<Bookmark>() {
        }, MockBackend.BOOKMARK_DEVICE);
    }

    @Override
    public Observable<Void> deleteBookmark(String userId, String deviceId) {
        return Observable.create(new Observable.OnSubscribe<Void>() {
            @Override
            public void call(Subscriber<? super Void> subscriber) {
                subscriber.onNext(null);
            }
        });
    }

    @Override
    public Observable<List<BookmarkDevice>> getBookmarkedDevices(String userId) {
        return mServer.createObservable(new TypeToken<List<BookmarkDevice>>() {
        }, MockBackend.BOOKMARKED_DEVICES);
    }

    @Override public Observable<List<Account>> getAccounts(String userId) {
        return mServer.createObservable(new TypeToken<List<Account>>() {
        }, MockBackend.USER_ACCOUNTS);
    }

    @Override
    public Observable<Void> isAccountConnected(String userId, String accountName) {
        return Observable.empty();
    }

    @Override
    public Observable<Void> disconnectAccount(String userId, String accountName) {
        return Observable.empty();
    }
}
