package io.relayr.java.api.mock;

import com.google.gson.reflect.TypeToken;

import javax.inject.Inject;

import io.relayr.java.api.DeviceModelsApi;
import io.relayr.java.model.models.DeviceFirmware;
import io.relayr.java.model.models.DeviceFirmwares;
import io.relayr.java.model.models.DeviceModels;
import io.relayr.java.model.models.ReadingMeanings;
import io.relayr.java.model.models.DeviceModel;
import rx.Observable;

public class MockDeviceModelsApi implements DeviceModelsApi {

    private final MockBackend mBackend;

    @Inject public MockDeviceModelsApi(MockBackend mockBackend) {
        mBackend = mockBackend;
    }

    @Override public Observable<ReadingMeanings> getReadingMeanings() {
        return mBackend.createObservable(new TypeToken<ReadingMeanings>() { }, MockBackend.DEVICE_READING_MEANINGS);
    }

    @Override public Observable<DeviceModels> getDeviceModels(int limit) {
        return mBackend.createObservable(new TypeToken<DeviceModels>() { }, MockBackend.DEVICE_MODELS);
    }

    @Override public Observable<DeviceModel> getDeviceModelById( String modelId) {
        return mBackend.createObservable(new TypeToken<DeviceModel>() { }, MockBackend.DEVICE_MODEL);
    }

    @Override
    public Observable<DeviceFirmwares> getDeviceModelFirmwares(String modelId) {
        return mBackend.createObservable(new TypeToken<DeviceFirmwares>() { }, MockBackend.DEVICE_MODEL_FIRMWARES);
    }

    @Override
    public Observable<DeviceFirmware> getDeviceModelByFirmware(String modelId, String version) {
        return mBackend.createObservable(new TypeToken<DeviceFirmware>() { }, MockBackend.DEVICE_MODEL_FIRMWARE);
    }

    @Override public Observable<DeviceModels> getUsersDeviceModels(String userId) {
        return mBackend.createObservable(new TypeToken<DeviceModels>() { }, MockBackend.DEVICE_MODELS);
    }

    @Override
    public Observable<DeviceModel> getUsersDeviceModelById(String userId, String modelId) {
        return mBackend.createObservable(new TypeToken<DeviceModel>() { }, MockBackend.DEVICE_MODEL);
    }

    @Override
    public Observable<DeviceFirmwares> getUsersDeviceModelFirmwares(String userId, String modelId) {
        return mBackend.createObservable(new TypeToken<DeviceFirmwares>() { }, MockBackend.DEVICE_MODEL_FIRMWARES);
    }

    @Override
    public Observable<DeviceFirmware> getUsersDeviceModelByFirmware(String userId, String modelId, String version) {
        return mBackend.createObservable(new TypeToken<DeviceFirmware>() { }, MockBackend.DEVICE_MODEL_FIRMWARE);
    }

}
