package io.relayr.java.api.mock;

import com.google.gson.reflect.TypeToken;

import java.util.List;

import javax.inject.Inject;

import io.relayr.java.api.AccountsApi;
import io.relayr.java.model.account.Account;
import io.relayr.java.model.account.AccountDevice;
import io.relayr.java.model.account.AccountUrl;
import rx.Observable;

public class MockAccountsApi implements AccountsApi {

    private final MockBackend mMockBackend;

    @Inject
    public MockAccountsApi(MockBackend mockBackend) {
        mMockBackend = mockBackend;
    }

    @Override public Observable<List<Account>> getAccounts() {
        return mMockBackend.createObservable(new TypeToken<List<Account>>() {
        }, MockBackend.USER_ACCOUNTS);
    }

    @Override
    public Observable<List<AccountDevice>> getAccountDevices(String accountName) {
        return mMockBackend.createObservable(new TypeToken<List<AccountDevice>>() {
        }, MockBackend.USER_ACCOUNT_DEVICES);
    }

    @Override
    public Observable<AccountUrl> getLoginUrl(String accountName, String redirectUri) {
        return mMockBackend.createObservable(new TypeToken<AccountUrl>() {
        }, MockBackend.USER_ACCOUNT_LOGIN_URL);
    }
}
