package io.relayr.java.api.mock;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;
import io.relayr.java.api.ChannelApi;
import io.relayr.java.api.GroupsApi;
import io.relayr.java.storage.DeviceModelCache;
import io.relayr.java.api.AccountsApi;
import io.relayr.java.api.CloudApi;
import io.relayr.java.api.DeviceModelsApi;
import io.relayr.java.api.OauthApi;
import io.relayr.java.api.RelayrApi;
import io.relayr.java.api.UserApi;

@Module(
        complete = false,
        library = true
)
public class DebugApiModule {

    @Provides @Singleton MockBackend provideMockBackend() {
        return new MockBackend();
    }

    @Provides @Singleton OauthApi provideOauthApi(MockBackend loader) {
        return new MockOauthApi(loader);
    }

    @Provides @Singleton RelayrApi provideRelayrApi(MockBackend loader) {
        return new MockRelayrApi(loader);
    }

    @Provides @Singleton ChannelApi provideChannelApi(MockBackend loader) {
        return new MockChannelApi(loader);
    }

    @Provides @Singleton AccountsApi provideAccountsApi(MockBackend loader) {
        return new MockAccountsApi(loader);
    }

    @Provides @Singleton UserApi provideUserApi(MockBackend loader) {
        return new MockUserApi(loader);
    }

    @Provides @Singleton GroupsApi provideGroupsApi(MockBackend loader) {
        return new MockGroupsApi(loader);
    }

    @Provides @Singleton CloudApi provideCloudApi(MockBackend loader) {
        return new MockCloudApi(loader);
    }

    @Provides @Singleton DeviceModelsApi provideDeviceModelsApi(MockBackend loader) {
        return new MockDeviceModelsApi(loader);
    }

    @Provides @Singleton DeviceModelCache provideDeviceModelCache(DeviceModelsApi modelsApi) {
        return new DeviceModelCache(modelsApi);
    }
}
