/*
 * Decompiled with CFR 0.152.
 */
package io.reflectoring.sqs.internal;

import io.reflectoring.sqs.internal.NamedThreadFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class ThreadPools {
    ThreadPools() {
    }

    public static ThreadPoolExecutor blockingThreadPool(int threads, int queueSize, String poolName) {
        return new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueSize), new NamedThreadFactory(poolName), ThreadPools.retryPolicy());
    }

    public static ScheduledThreadPoolExecutor blockingScheduledThreadPool(int threads, String poolName) {
        return new ScheduledThreadPoolExecutor(threads, new NamedThreadFactory(poolName), ThreadPools.retryPolicy());
    }

    static RejectedExecutionHandler retryPolicy() {
        return (r, executor) -> {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

