/*
 * Decompiled with CFR 0.152.
 */
package io.reflectoring.sqs.internal;

import io.reflectoring.sqs.api.SqsMessageHandlerRegistration;
import io.reflectoring.sqs.internal.SqsMessageFetcher;
import io.reflectoring.sqs.internal.SqsMessagePoller;
import io.reflectoring.sqs.internal.ThreadPools;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SqsMessageHandlerRegistry {
    private static final Logger logger = LoggerFactory.getLogger(SqsMessageHandlerRegistry.class);
    private final Set<SqsMessagePoller<?>> pollers;

    public SqsMessageHandlerRegistry(List<SqsMessageHandlerRegistration<?>> messageHandlerRegistrations) {
        this.pollers = this.initializePollers(messageHandlerRegistrations);
    }

    private Set<SqsMessagePoller<?>> initializePollers(List<SqsMessageHandlerRegistration<?>> registrations) {
        HashSet pollers = new HashSet();
        for (SqsMessageHandlerRegistration<?> registration : registrations) {
            pollers.add(this.createPollerForHandler(registration));
            logger.info("initialized SqsMessagePoller '{}'", (Object)registration.name());
        }
        return pollers;
    }

    private SqsMessagePoller<?> createPollerForHandler(SqsMessageHandlerRegistration<?> registration) {
        return new SqsMessagePoller(registration.name(), registration.messageHandler(), this.createFetcherForHandler(registration), registration.messagePollerProperties(), registration.sqsClient(), registration.objectMapper(), this.createPollingThreadPool(registration), this.createHandlerThreadPool(registration), registration.messagePollerProperties().getExceptionHandler());
    }

    private SqsMessageFetcher createFetcherForHandler(SqsMessageHandlerRegistration<?> registration) {
        return new SqsMessageFetcher(registration.sqsClient(), registration.messagePollerProperties());
    }

    private ScheduledThreadPoolExecutor createPollingThreadPool(SqsMessageHandlerRegistration<?> registration) {
        return ThreadPools.blockingScheduledThreadPool(registration.messagePollerProperties().getPollingThreads(), String.format("%s-poller", registration.name()));
    }

    private ThreadPoolExecutor createHandlerThreadPool(SqsMessageHandlerRegistration<?> registration) {
        return ThreadPools.blockingThreadPool(registration.messageHandlerProperties().getHandlerThreadPoolSize(), registration.messageHandlerProperties().getHandlerQueueSize(), String.format("%s-handler", registration.name()));
    }

    public void start() {
        for (SqsMessagePoller<?> poller : this.pollers) {
            poller.start();
        }
    }

    public void stop() {
        for (SqsMessagePoller<?> poller : this.pollers) {
            poller.stop();
        }
    }
}

