/*
 * Decompiled with CFR 0.152.
 */
package io.reflectoring.sqs.internal;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import io.reflectoring.sqs.api.SqsMessagePollerProperties;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SqsMessageFetcher {
    private static final Logger logger = LoggerFactory.getLogger(SqsMessageFetcher.class);
    private final AmazonSQS sqsClient;
    private final SqsMessagePollerProperties properties;

    List<Message> fetchMessages() {
        logger.debug("fetching messages from SQS queue {}", (Object)this.properties.getQueueUrl());
        ReceiveMessageRequest request = new ReceiveMessageRequest().withMaxNumberOfMessages(Integer.valueOf(this.properties.getBatchSize())).withQueueUrl(this.properties.getQueueUrl()).withWaitTimeSeconds(Integer.valueOf((int)this.properties.getWaitTime().getSeconds()));
        ReceiveMessageResult result = this.sqsClient.receiveMessage(request);
        if (result.getSdkHttpMetadata() == null) {
            logger.error("cannot determine success from response for SQS queue {}: {}", (Object)this.properties.getQueueUrl(), (Object)result.getSdkResponseMetadata());
            return Collections.emptyList();
        }
        if (result.getSdkHttpMetadata().getHttpStatusCode() != 200) {
            logger.error("got error response from SQS queue {}: {}", (Object)this.properties.getQueueUrl(), (Object)result.getSdkHttpMetadata());
            return Collections.emptyList();
        }
        logger.debug("polled {} messages from SQS queue {}", (Object)result.getMessages().size(), (Object)this.properties.getQueueUrl());
        return result.getMessages();
    }

    @Generated
    public SqsMessageFetcher(AmazonSQS sqsClient, SqsMessagePollerProperties properties) {
        this.sqsClient = sqsClient;
        this.properties = properties;
    }
}

