/*
 * Decompiled with CFR 0.152.
 */
package io.reflectoring.sqs.api;

import com.amazonaws.services.sqs.model.Message;
import io.reflectoring.sqs.api.ExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WarningOrErrorExceptionHandler
implements ExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(WarningOrErrorExceptionHandler.class);

    @Override
    public ExceptionHandler.ExceptionHandlerDecision handleException(Message message, Exception e) {
        if (this.isKnownError(e)) {
            logger.warn("Known exception when processing message {} (reason: {}). Message has not been deleted from SQS and will be retried.", (Object)message.getMessageId(), (Object)this.getWarnMessageForKnownError(e));
        } else {
            logger.warn("error while processing message {} - message has not been deleted from SQS and will be retried:", (Object)message.getMessageId(), (Object)e);
        }
        return ExceptionHandler.ExceptionHandlerDecision.RETRY;
    }

    protected abstract boolean isKnownError(Throwable var1);

    protected String getWarnMessageForKnownError(Throwable e) {
        return e.getMessage();
    }
}

