/*
 * Decompiled with CFR 0.152.
 */
package io.reflectoring.sqs.api;

import io.reflectoring.sqs.api.ExceptionHandler;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import lombok.Generated;

public class SqsMessagePollerProperties {
    private final String queueUrl;
    private Duration pollDelay = Duration.of(1L, ChronoUnit.SECONDS);
    private Duration waitTime = Duration.ofSeconds(1L);
    private int batchSize = 10;
    private int pollingThreads = 1;
    private ExceptionHandler exceptionHandler = ExceptionHandler.defaultExceptionHandler();

    public SqsMessagePollerProperties(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public SqsMessagePollerProperties withPollDelay(Duration pollDelay) {
        this.pollDelay = pollDelay;
        return this;
    }

    public SqsMessagePollerProperties withWaitTime(Duration waitTime) {
        this.waitTime = waitTime;
        return this;
    }

    public SqsMessagePollerProperties withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public SqsMessagePollerProperties withExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public SqsMessagePollerProperties withPollingThreads(int pollingThreads) {
        this.pollingThreads = pollingThreads;
        return this;
    }

    @Generated
    public String getQueueUrl() {
        return this.queueUrl;
    }

    @Generated
    public Duration getPollDelay() {
        return this.pollDelay;
    }

    @Generated
    public Duration getWaitTime() {
        return this.waitTime;
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public int getPollingThreads() {
        return this.pollingThreads;
    }

    @Generated
    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Generated
    public void setPollDelay(Duration pollDelay) {
        this.pollDelay = pollDelay;
    }

    @Generated
    public void setWaitTime(Duration waitTime) {
        this.waitTime = waitTime;
    }

    @Generated
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Generated
    public void setPollingThreads(int pollingThreads) {
        this.pollingThreads = pollingThreads;
    }

    @Generated
    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqsMessagePollerProperties)) {
            return false;
        }
        SqsMessagePollerProperties other = (SqsMessagePollerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$queueUrl = this.getQueueUrl();
        String other$queueUrl = other.getQueueUrl();
        if (this$queueUrl == null ? other$queueUrl != null : !this$queueUrl.equals(other$queueUrl)) {
            return false;
        }
        Duration this$pollDelay = this.getPollDelay();
        Duration other$pollDelay = other.getPollDelay();
        if (this$pollDelay == null ? other$pollDelay != null : !((Object)this$pollDelay).equals(other$pollDelay)) {
            return false;
        }
        Duration this$waitTime = this.getWaitTime();
        Duration other$waitTime = other.getWaitTime();
        if (this$waitTime == null ? other$waitTime != null : !((Object)this$waitTime).equals(other$waitTime)) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.getPollingThreads() != other.getPollingThreads()) {
            return false;
        }
        ExceptionHandler this$exceptionHandler = this.getExceptionHandler();
        ExceptionHandler other$exceptionHandler = other.getExceptionHandler();
        return !(this$exceptionHandler == null ? other$exceptionHandler != null : !this$exceptionHandler.equals(other$exceptionHandler));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SqsMessagePollerProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $queueUrl = this.getQueueUrl();
        result = result * 59 + ($queueUrl == null ? 43 : $queueUrl.hashCode());
        Duration $pollDelay = this.getPollDelay();
        result = result * 59 + ($pollDelay == null ? 43 : ((Object)$pollDelay).hashCode());
        Duration $waitTime = this.getWaitTime();
        result = result * 59 + ($waitTime == null ? 43 : ((Object)$waitTime).hashCode());
        result = result * 59 + this.getBatchSize();
        result = result * 59 + this.getPollingThreads();
        ExceptionHandler $exceptionHandler = this.getExceptionHandler();
        result = result * 59 + ($exceptionHandler == null ? 43 : $exceptionHandler.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SqsMessagePollerProperties(queueUrl=" + this.getQueueUrl() + ", pollDelay=" + this.getPollDelay() + ", waitTime=" + this.getWaitTime() + ", batchSize=" + this.getBatchSize() + ", pollingThreads=" + this.getPollingThreads() + ", exceptionHandler=" + this.getExceptionHandler() + ")";
    }
}

