/*
 * Decompiled with CFR 0.152.
 */
package io.reflectoring.devtools;

import io.reflectoring.devtools.DevToolsPluginConfig;
import io.reflectoring.devtools.ModuleConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.gradle.api.tasks.Copy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0002H\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0002H\u0016J\b\u0010\u0010\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\nH\u0002R\u001a\u0010\u0004\u001a\u00020\u0002X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lio/reflectoring/devtools/DevToolsPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "project", "getProject", "()Lorg/gradle/api/Project;", "setProject", "(Lorg/gradle/api/Project;)V", "addDevToolsDependency", "", "addOrCreateConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "configurationName", "", "apply", "createExtension", "createReloadClassesTaskForModule", "Lorg/gradle/api/Task;", "module", "Lorg/gradle/api/artifacts/ResolvedDependency;", "createReloadResourcesTaskForModule", "createRestartTask", "tasks", "", "getExtension", "Lio/reflectoring/devtools/DevToolsPluginConfig;", "toFullDependencyString", "dependencyRootDir", "Ljava/io/File;", "touchTriggerFile", "Companion", "plugin"})
public final class DevToolsPlugin
implements Plugin<Project> {
    @NotNull
    public Project project;
    @NotNull
    public static final String EXTENSION_NAME = "devtools";
    @NotNull
    public static final String RESTART_CONFIGURATION_NAME = "restart";
    @NotNull
    public static final String RESTART_TASK_NAME = "restart";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Project getProject() {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        return project;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"<set-?>");
        this.project = project;
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.createExtension();
        Configuration reloadConfiguration = this.addOrCreateConfiguration(project, "restart");
        project.afterEvaluate((Action)new Action<Project>(this, project, reloadConfiguration){
            final /* synthetic */ DevToolsPlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Configuration $reloadConfiguration;

            public final void execute(Project it) {
                DevToolsPlugin.access$addDevToolsDependency(this.this$0, this.$project);
                boolean bl = false;
                List tasks = new ArrayList<E>();
                this.$reloadConfiguration.resolve();
                ResolvedConfiguration resolvedConfiguration = this.$reloadConfiguration.getResolvedConfiguration();
                Intrinsics.checkExpressionValueIsNotNull((Object)resolvedConfiguration, (String)"reloadConfiguration.resolvedConfiguration");
                Set set = resolvedConfiguration.getFirstLevelModuleDependencies();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"reloadConfiguration.reso\u2026stLevelModuleDependencies");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ResolvedDependency dependency = (ResolvedDependency)element$iv;
                    boolean bl2 = false;
                    ResolvedDependency resolvedDependency = dependency;
                    Intrinsics.checkExpressionValueIsNotNull((Object)resolvedDependency, (String)"dependency");
                    tasks.add(DevToolsPlugin.access$createReloadClassesTaskForModule(this.this$0, resolvedDependency));
                    tasks.add(DevToolsPlugin.access$createReloadResourcesTaskForModule(this.this$0, dependency));
                }
                DevToolsPlugin.access$createRestartTask(this.this$0, this.$project, tasks);
            }
            {
                this.this$0 = devToolsPlugin;
                this.$project = project;
                this.$reloadConfiguration = configuration;
            }
        });
    }

    private final void createExtension() {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        NamedDomainObjectContainer modules = project.container(ModuleConfig.class);
        Project project2 = this.project;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        project2.getExtensions().create(EXTENSION_NAME, DevToolsPluginConfig.class, new Object[]{modules});
    }

    private final DevToolsPluginConfig getExtension() {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        Object object = project.getExtensions().findByName(EXTENSION_NAME);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.reflectoring.devtools.DevToolsPluginConfig");
        }
        return (DevToolsPluginConfig)object;
    }

    private final void createRestartTask(Project project, List<? extends Task> tasks) {
        Task restartTask;
        Task task = restartTask = project.getTasks().create("restart");
        Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"restartTask");
        task.getActions().add(new Action<Task>(this){
            final /* synthetic */ DevToolsPlugin this$0;

            public final void execute(Task it) {
                DevToolsPlugin.access$touchTriggerFile(this.this$0);
            }
            {
                this.this$0 = devToolsPlugin;
            }
        });
        for (Task task2 : tasks) {
            restartTask.dependsOn(new Object[]{task2});
        }
        restartTask.dependsOn(new Object[]{"compileJava"});
        restartTask.dependsOn(new Object[]{"processResources"});
    }

    private final Task createReloadClassesTaskForModule(ResolvedDependency module) {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        Copy reloadClassesTask = (Copy)project.getTasks().create("reloadClassesFrom" + module.getModuleName(), Copy.class);
        Set set = module.getModuleArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"module.moduleArtifacts");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File dependencyRootDir;
            ResolvedArtifact it = (ResolvedArtifact)element$iv;
            boolean bl = false;
            ResolvedArtifact resolvedArtifact = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifact, (String)"it");
            if (!Intrinsics.areEqual((Object)resolvedArtifact.getType(), (Object)"jar")) continue;
            File file = it.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it.file");
            File file2 = file.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.file.parentFile");
            String classesFolder = new File(file2.getParentFile(), "classes").getAbsolutePath();
            reloadClassesTask.from(new Object[]{classesFolder});
            reloadClassesTask.into((Object)"build/classes");
            File file3 = it.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"it.file");
            File file4 = file3.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"it.file.parentFile");
            File file5 = file4.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"it.file.parentFile.parentFile");
            File file6 = dependencyRootDir = file5.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"dependencyRootDir");
            String dependencyString = this.toFullDependencyString(file6);
            ModuleConfig moduleConfig2 = this.getExtension().getModuleConfig$plugin(dependencyString);
            reloadClassesTask.dependsOn(new Object[]{moduleConfig2.getDependency() + ':' + moduleConfig2.getClassesTask()});
            Copy copy = reloadClassesTask;
            Intrinsics.checkExpressionValueIsNotNull((Object)copy, (String)"reloadClassesTask");
            return (Task)copy;
        }
        throw (Throwable)new IllegalStateException("Module " + module.getModuleName() + " does not publish a JAR file!");
    }

    private final Task createReloadResourcesTaskForModule(ResolvedDependency module) {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        Copy reloadResourcesTask = (Copy)project.getTasks().create("reloadResourcesFrom" + module.getModuleName(), Copy.class);
        Set set = module.getModuleArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"module.moduleArtifacts");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File dependencyRootDir;
            ResolvedArtifact it = (ResolvedArtifact)element$iv;
            boolean bl = false;
            ResolvedArtifact resolvedArtifact = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifact, (String)"it");
            File file = resolvedArtifact.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it.file");
            String string = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.file.path");
            if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) continue;
            File file2 = it.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.file");
            File file3 = file2.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"it.file.parentFile");
            String resourcesFolder = new File(file3.getParentFile(), "resources").getAbsolutePath();
            reloadResourcesTask.from(new Object[]{resourcesFolder});
            reloadResourcesTask.into((Object)"build/resources");
            File file4 = it.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"it.file");
            File file5 = file4.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"it.file.parentFile");
            File file6 = file5.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"it.file.parentFile.parentFile");
            File file7 = dependencyRootDir = file6.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file7, (String)"dependencyRootDir");
            String dependencyString = this.toFullDependencyString(file7);
            ModuleConfig moduleConfig2 = this.getExtension().getModuleConfig$plugin(dependencyString);
            reloadResourcesTask.dependsOn(new Object[]{moduleConfig2.getDependency() + ':' + moduleConfig2.getResourcesTask()});
            Copy copy = reloadResourcesTask;
            Intrinsics.checkExpressionValueIsNotNull((Object)copy, (String)"reloadResourcesTask");
            return (Task)copy;
        }
        throw (Throwable)new IllegalStateException("Module " + module.getModuleName() + " does not publish a JAR file!");
    }

    private final void touchTriggerFile() {
        File triggerFile;
        String triggerFileName = this.getExtension().getTriggerFile();
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        if (!(triggerFile = new File(project.getBuildDir(), triggerFileName)).exists()) {
            triggerFile.createNewFile();
        } else {
            triggerFile.setLastModified(System.currentTimeMillis());
        }
    }

    private final String toFullDependencyString(File dependencyRootDir) {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        File rootDir = project2.getRootDir();
        String string = dependencyRootDir.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dependencyRootDir.absolutePath");
        File file = rootDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"rootDir");
        String string2 = file.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"rootDir.absolutePath");
        String relativePath = StringsKt.replaceFirst$default((String)string, (String)string2, (String)"", (boolean)false, (int)4, null);
        return StringsKt.replace$default((String)relativePath, (String)"/", (String)":", (boolean)false, (int)4, null);
    }

    private final void addDevToolsDependency(Project project) {
        Object v2;
        Plugin springBootPlugin;
        Configuration developmentOnlyConfiguration;
        block3: {
            developmentOnlyConfiguration = this.addOrCreateConfiguration(project, "developmentOnly");
            springBootPlugin = project.getPlugins().findPlugin("org.springframework.boot");
            DependencySet dependencySet = developmentOnlyConfiguration.getDependencies();
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencySet, (String)"developmentOnlyConfiguration.dependencies");
            Iterable iterable = (Iterable)dependencySet;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Dependency it = (Dependency)t;
                boolean bl3 = false;
                Dependency dependency = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)dependency, (String)"it");
                if (!Intrinsics.areEqual((Object)dependency.getName(), (Object)"spring-boot-devtools")) continue;
                v2 = t;
                break block3;
            }
            v2 = null;
        }
        Dependency devToolsDependency = v2;
        if (devToolsDependency != null) {
            return;
        }
        if (springBootPlugin != null) {
            project.getDependencies().add(developmentOnlyConfiguration.getName(), (Object)"org.springframework.boot:spring-boot-devtools");
            return;
        }
        project.getDependencies().add(developmentOnlyConfiguration.getName(), (Object)"org.springframework.boot:spring-boot-devtools:2.3.2.RELEASE");
    }

    private final Configuration addOrCreateConfiguration(Project project, String configurationName) {
        Configuration configuration;
        try {
            Configuration configuration2 = project.getConfigurations().getByName(configurationName);
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"project.configurations.g\u2026ByName(configurationName)");
            configuration = configuration2;
        }
        catch (UnknownConfigurationException e) {
            Object object = project.getConfigurations().create(configurationName);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.configurations.create(configurationName)");
            configuration = (Configuration)object;
        }
        return configuration;
    }

    public static final /* synthetic */ void access$addDevToolsDependency(DevToolsPlugin $this, Project project) {
        $this.addDevToolsDependency(project);
    }

    public static final /* synthetic */ Task access$createReloadClassesTaskForModule(DevToolsPlugin $this, ResolvedDependency module) {
        return $this.createReloadClassesTaskForModule(module);
    }

    public static final /* synthetic */ Task access$createReloadResourcesTaskForModule(DevToolsPlugin $this, ResolvedDependency module) {
        return $this.createReloadResourcesTaskForModule(module);
    }

    public static final /* synthetic */ void access$createRestartTask(DevToolsPlugin $this, Project project, List tasks) {
        $this.createRestartTask(project, tasks);
    }

    public static final /* synthetic */ void access$touchTriggerFile(DevToolsPlugin $this) {
        $this.touchTriggerFile();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/reflectoring/devtools/DevToolsPlugin$Companion;", "", "()V", "EXTENSION_NAME", "", "RESTART_CONFIGURATION_NAME", "RESTART_TASK_NAME", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

