/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bootgraph.api.mapper;

import com.atlassian.bootgraph.api.model.ExternalNode;
import com.atlassian.bootgraph.api.model.GraphModel;
import com.atlassian.bootgraph.api.model.InternalNode;
import com.atlassian.bootgraph.api.model.Node;
import com.atlassian.bootgraph.spring.SpelEvaluator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.env.Environment;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/bootgraph/api/mapper/NodeFactory;", "", "model", "Lcom/atlassian/bootgraph/api/model/GraphModel;", "environment", "Lorg/springframework/core/env/Environment;", "(Lcom/atlassian/bootgraph/api/model/GraphModel;Lorg/springframework/core/env/Environment;)V", "getEnvironment", "()Lorg/springframework/core/env/Environment;", "getModel", "()Lcom/atlassian/bootgraph/api/model/GraphModel;", "spelEvaluator", "Lcom/atlassian/bootgraph/spring/SpelEvaluator;", "externalNode", "Lcom/atlassian/bootgraph/api/model/Node;", "name", "", "getExistingNode", "internalNode", "bootgraph-core"})
public final class NodeFactory {
    private final SpelEvaluator spelEvaluator;
    @NotNull
    private final GraphModel model;
    @NotNull
    private final Environment environment;

    @NotNull
    public final Node internalNode(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String evaluatedName = this.spelEvaluator.evaluateSpel(name, this.environment);
        Node node = this.model.getNode(evaluatedName);
        if (node == null) {
            node = new InternalNode(evaluatedName);
        }
        return node;
    }

    @NotNull
    public final Node externalNode(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String evaluatedName = this.spelEvaluator.evaluateSpel(name, this.environment);
        Node node = this.model.getNode(evaluatedName);
        if (node == null) {
            node = new ExternalNode(evaluatedName);
        }
        return node;
    }

    @NotNull
    public final Node getExistingNode(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String evaluatedName = this.spelEvaluator.evaluateSpel(name, this.environment);
        Node node = this.model.getNode(evaluatedName);
        if (node == null) {
            throw (Throwable)new IllegalStateException("Node " + evaluatedName + " doesn't exist.");
        }
        return node;
    }

    @NotNull
    public final GraphModel getModel() {
        return this.model;
    }

    @NotNull
    public final Environment getEnvironment() {
        return this.environment;
    }

    public NodeFactory(@NotNull GraphModel model, @NotNull Environment environment) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        this.model = model;
        this.environment = environment;
        this.spelEvaluator = new SpelEvaluator();
    }
}

