/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bootgraph.spring;

import com.atlassian.bootgraph.api.generator.NodeGenerator;
import com.atlassian.bootgraph.api.mapper.BeanMapper;
import com.atlassian.bootgraph.api.mapper.InputNodeMapper;
import com.atlassian.bootgraph.api.mapper.NodeFactory;
import com.atlassian.bootgraph.api.mapper.OutputNodeMapper;
import com.atlassian.bootgraph.api.matcher.BeanMatcher;
import com.atlassian.bootgraph.api.matcher.InputNodeMatcher;
import com.atlassian.bootgraph.api.matcher.OutputNodeMatcher;
import com.atlassian.bootgraph.api.model.GraphModel;
import com.atlassian.bootgraph.api.model.Node;
import com.atlassian.bootgraph.spring.SpelEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\rJ,\u0010\u0015\u001a\u00020\u00162\"\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0018j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0019`\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJB\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00032\"\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0018j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0019`\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/atlassian/bootgraph/spring/SpringNodeFactory;", "", "applicationName", "", "applicationContext", "Lorg/springframework/context/ConfigurableApplicationContext;", "(Ljava/lang/String;Lorg/springframework/context/ConfigurableApplicationContext;)V", "generators", "", "Lcom/atlassian/bootgraph/api/generator/NodeGenerator;", "mappers", "", "Lcom/atlassian/bootgraph/api/matcher/BeanMatcher;", "Lcom/atlassian/bootgraph/api/mapper/BeanMapper;", "spelEvaluator", "Lcom/atlassian/bootgraph/spring/SpelEvaluator;", "addGenerator", "generator", "addMapper", "matcher", "mapper", "connectDependentNodes", "", "beanNameToModel", "Ljava/util/HashMap;", "Lcom/atlassian/bootgraph/api/model/Node;", "Lkotlin/collections/HashMap;", "createApplicationModel", "Lcom/atlassian/bootgraph/api/model/GraphModel;", "findDependentNodes", "beanName", "found", "", "Companion", "bootgraph-core"})
public final class SpringNodeFactory {
    private final Map<BeanMatcher, BeanMapper> mappers;
    private final List<NodeGenerator> generators;
    private final SpelEvaluator spelEvaluator;
    private final String applicationName;
    private final ConfigurableApplicationContext applicationContext;
    @NotNull
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public final SpringNodeFactory addMapper(@NotNull BeanMatcher matcher, @NotNull BeanMapper mapper) {
        Intrinsics.checkParameterIsNotNull((Object)matcher, (String)"matcher");
        Intrinsics.checkParameterIsNotNull((Object)mapper, (String)"mapper");
        this.mappers.put(matcher, mapper);
        return this;
    }

    @NotNull
    public final SpringNodeFactory addGenerator(@NotNull NodeGenerator generator) {
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        this.generators.add(generator);
        return this;
    }

    @NotNull
    public final GraphModel createApplicationModel() {
        GraphModel graphModel = new GraphModel(this.applicationName);
        ConfigurableEnvironment configurableEnvironment = this.applicationContext.getEnvironment();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableEnvironment, (String)"applicationContext.environment");
        NodeFactory nodeFactory = new NodeFactory(graphModel, (Environment)configurableEnvironment);
        HashMap<String, Node> beanNameToModel = new HashMap<String, Node>();
        ConfigurableListableBeanFactory configurableListableBeanFactory = this.applicationContext.getBeanFactory();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableListableBeanFactory, (String)"applicationContext.beanFactory");
        Iterator<NodeGenerator> iterator = configurableListableBeanFactory.getBeanNamesIterator();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"applicationContext.beanFactory.beanNamesIterator");
        Iterator<NodeGenerator> iterator2 = iterator;
        boolean bl = false;
        Iterator<NodeGenerator> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            String beanName = (String)iterator3.next();
            try {
                BeanDefinition beanDefinition = this.applicationContext.getBeanFactory().getBeanDefinition(beanName);
                Object bean = this.applicationContext.getBean(beanName);
                Map<BeanMatcher, BeanMapper> map = this.mappers;
                boolean bl2 = false;
                Iterator<Map.Entry<BeanMatcher, BeanMapper>> iterator4 = map.entrySet().iterator();
                while (iterator4.hasNext()) {
                    Map.Entry<BeanMatcher, BeanMapper> entry;
                    Map.Entry<BeanMatcher, BeanMapper> entry2 = entry = iterator4.next();
                    boolean bl3 = false;
                    BeanMatcher matcher = entry2.getKey();
                    entry2 = entry;
                    bl3 = false;
                    BeanMapper mapper = entry2.getValue();
                    Object object = bean;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bean");
                    String string = beanName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"beanName");
                    BeanDefinition beanDefinition2 = beanDefinition;
                    Intrinsics.checkExpressionValueIsNotNull((Object)beanDefinition2, (String)"beanDefinition");
                    if (!matcher.matches(object, string, beanDefinition2, this.applicationContext)) continue;
                    logger.debug("matcher '{}' MATCHED bean '{}'", (Object)matcher.getClass().getSimpleName(), (Object)beanName);
                    Optional<Node> beanNode = mapper.mapToGraph(bean, beanName, beanDefinition, this.applicationContext, nodeFactory);
                    if (!beanNode.isPresent()) {
                        logger.debug("mapper '{}' DID NOT MAP bean '{}' to graph node", (Object)mapper.getClass().getSimpleName(), (Object)beanName);
                        continue;
                    }
                    logger.info("mapper '{}' MAPPED bean '{}' to graph node '{}'", new Object[]{mapper.getClass().getSimpleName(), beanName, beanNode.get()});
                    Node node = beanNode.get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"beanNode.get()");
                    ConfigurableEnvironment configurableEnvironment2 = this.applicationContext.getEnvironment();
                    Intrinsics.checkExpressionValueIsNotNull((Object)configurableEnvironment2, (String)"applicationContext.environment");
                    Node evaluatedBeanNode = this.spelEvaluator.evaluateSpringExpressions(node, nodeFactory, (Environment)configurableEnvironment2);
                    graphModel.addNode(evaluatedBeanNode);
                    ((Map)beanNameToModel).put(beanName, evaluatedBeanNode);
                }
            }
            catch (NoSuchBeanDefinitionException beanDefinition) {
            }
        }
        this.connectDependentNodes(beanNameToModel);
        for (NodeGenerator generator : this.generators) {
            Node node = generator.generateNode(nodeFactory);
            ConfigurableEnvironment configurableEnvironment3 = this.applicationContext.getEnvironment();
            Intrinsics.checkExpressionValueIsNotNull((Object)configurableEnvironment3, (String)"applicationContext.environment");
            Node evaluatedBeanNode = this.spelEvaluator.evaluateSpringExpressions(node, nodeFactory, (Environment)configurableEnvironment3);
            graphModel.addNode(evaluatedBeanNode);
        }
        return graphModel;
    }

    private final void connectDependentNodes(HashMap<String, Node> beanNameToModel) {
        Iterator<Map.Entry<String, Node>> iterator = beanNameToModel.entrySet().iterator();
        while (iterator.hasNext()) {
            Node thisNode;
            Map.Entry<String, Node> entry;
            Map.Entry<String, Node> entry2 = entry = iterator.next();
            boolean bl = false;
            String beanName = entry2.getKey();
            entry2 = entry;
            bl = false;
            Node model = entry2.getValue();
            if (beanNameToModel.get(beanName) == null) {
                throw (Throwable)new IllegalStateException("cannot find bean " + beanName + '!');
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)thisNode, (String)"beanNameToModel[beanName\u2026ot find bean $beanName!\")");
            HashSet dependentNodes = new HashSet();
            String string = beanName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"beanName");
            this.findDependentNodes(string, beanNameToModel, dependentNodes);
            for (Node dependentNode : dependentNodes) {
                dependentNode.addEdgeTo(thisNode, "");
            }
        }
    }

    private final void findDependentNodes(String beanName, HashMap<String, Node> beanNameToModel, Collection<Node> found) {
        for (String dependentBeanName : this.applicationContext.getBeanFactory().getDependentBeans(beanName)) {
            Node node;
            if (beanNameToModel.get(dependentBeanName) == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            Node it = node;
            boolean bl3 = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)beanNameToModel.get(beanName)) ^ true)) continue;
            Node node2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"it");
            found.add(node2);
        }
    }

    private SpringNodeFactory(String applicationName, ConfigurableApplicationContext applicationContext) {
        this.applicationName = applicationName;
        this.applicationContext = applicationContext;
        this.mappers = new HashMap();
        this.generators = new ArrayList();
        this.spelEvaluator = new SpelEvaluator();
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(SpringNodeFactory.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(\u2026gNodeFactory::class.java)");
        SpringNodeFactory.logger = logger;
    }

    public /* synthetic */ SpringNodeFactory(String applicationName, ConfigurableApplicationContext applicationContext, DefaultConstructorMarker $constructor_marker) {
        this(applicationName, applicationContext);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/bootgraph/spring/SpringNodeFactory$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "defaultInstance", "Lcom/atlassian/bootgraph/spring/SpringNodeFactory;", "applicationName", "", "applicationContext", "Lorg/springframework/context/ConfigurableApplicationContext;", "nakedInstance", "bootgraph-core"})
    public static final class Companion {
        @NotNull
        public final SpringNodeFactory defaultInstance(@NotNull String applicationName, @NotNull ConfigurableApplicationContext applicationContext) {
            Intrinsics.checkParameterIsNotNull((Object)applicationName, (String)"applicationName");
            Intrinsics.checkParameterIsNotNull((Object)applicationContext, (String)"applicationContext");
            return new SpringNodeFactory(applicationName, applicationContext, null).addMapper(new OutputNodeMatcher(), new OutputNodeMapper()).addMapper(new InputNodeMatcher(), new InputNodeMapper());
        }

        @NotNull
        public final SpringNodeFactory nakedInstance(@NotNull String applicationName, @NotNull ConfigurableApplicationContext applicationContext) {
            Intrinsics.checkParameterIsNotNull((Object)applicationName, (String)"applicationName");
            Intrinsics.checkParameterIsNotNull((Object)applicationContext, (String)"applicationContext");
            return new SpringNodeFactory(applicationName, applicationContext, null);
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

