/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bootgraph.api.mapper;

import com.atlassian.bootgraph.annotations.InputNode;
import com.atlassian.bootgraph.api.mapper.BeanMapper;
import com.atlassian.bootgraph.api.mapper.NodeFactory;
import com.atlassian.bootgraph.api.model.InternalNode;
import com.atlassian.bootgraph.api.model.Node;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J6\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/bootgraph/api/mapper/InputNodeMapper;", "Lcom/atlassian/bootgraph/api/mapper/BeanMapper;", "()V", "getAnnotationFromBean", "Lcom/atlassian/bootgraph/annotations/InputNode;", "bean", "", "getAnnotationFromFactoryMethod", "beanDefinition", "Lorg/springframework/beans/factory/config/BeanDefinition;", "mapToGraph", "Ljava/util/Optional;", "Lcom/atlassian/bootgraph/api/model/Node;", "beanName", "", "applicationContext", "Lorg/springframework/context/ConfigurableApplicationContext;", "factory", "Lcom/atlassian/bootgraph/api/mapper/NodeFactory;", "bootgraph-core"})
public final class InputNodeMapper
implements BeanMapper {
    @Override
    @NotNull
    public Optional<Node> mapToGraph(@NotNull Object bean, @NotNull String beanName, @NotNull BeanDefinition beanDefinition, @NotNull ConfigurableApplicationContext applicationContext, @NotNull NodeFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)bean, (String)"bean");
        Intrinsics.checkParameterIsNotNull((Object)beanName, (String)"beanName");
        Intrinsics.checkParameterIsNotNull((Object)beanDefinition, (String)"beanDefinition");
        Intrinsics.checkParameterIsNotNull((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        InputNode inputNode = this.getAnnotationFromBean(bean);
        if (inputNode == null) {
            inputNode = this.getAnnotationFromFactoryMethod(beanDefinition);
        }
        if (inputNode == null) {
            throw (Throwable)new IllegalStateException("cannot find annotation @InputNode on class " + bean.getClass());
        }
        InputNode annotation = inputNode;
        InternalNode node = new InternalNode(StringsKt.isBlank((CharSequence)annotation.name()) ? beanName : annotation.name());
        Node inputNode2 = factory.externalNode(annotation.source());
        node.addEdgeFrom(inputNode2, annotation.connectionLabel());
        Optional<Node> optional = Optional.of(node);
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.of(node)");
        return optional;
    }

    private final InputNode getAnnotationFromFactoryMethod(BeanDefinition beanDefinition) {
        if (!(beanDefinition instanceof AnnotatedBeanDefinition)) {
            return null;
        }
        Object object = ((AnnotatedBeanDefinition)beanDefinition).getFactoryMethodMetadata();
        if (object == null || (object = object.getAnnotationAttributes(InputNode.class.getName())) == null) {
            throw (Throwable)new IllegalStateException("could not find @InputNode annotation on bean " + ((AnnotatedBeanDefinition)beanDefinition).getBeanClassName());
        }
        Object annotationAttributes = object;
        Object v = annotationAttributes.get("name");
        if (v == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String name = (String)v;
        Object v2 = annotationAttributes.get("source");
        if (v2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String source = (String)v2;
        Object v3 = annotationAttributes.get("connectionLabel");
        if (v3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String connectionLabel = (String)v3;
        return (InputNode)((KFunction)CollectionsKt.first((Iterable)Reflection.getOrCreateKotlinClass(InputNode.class).getConstructors())).call(new Object[]{name, connectionLabel, source});
    }

    private final InputNode getAnnotationFromBean(Object bean) {
        return bean.getClass().getAnnotation(InputNode.class);
    }
}

