/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bootgraph.api.generator;

import com.atlassian.bootgraph.api.generator.NodeGenerator;
import com.atlassian.bootgraph.api.mapper.NodeFactory;
import com.atlassian.bootgraph.api.model.Node;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/bootgraph/api/generator/EdgeGenerator;", "Lcom/atlassian/bootgraph/api/generator/NodeGenerator;", "fromNode", "", "toNode", "label", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFromNode", "()Ljava/lang/String;", "getLabel", "getToNode", "generateNode", "Lcom/atlassian/bootgraph/api/model/Node;", "factory", "Lcom/atlassian/bootgraph/api/mapper/NodeFactory;", "bootgraph-core"})
public final class EdgeGenerator
implements NodeGenerator {
    @NotNull
    private final String fromNode;
    @NotNull
    private final String toNode;
    @Nullable
    private final String label;

    @Override
    @NotNull
    public Node generateNode(@NotNull NodeFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        Node from = factory.getExistingNode(this.fromNode);
        Node to = factory.getExistingNode(this.toNode);
        from.addEdgeTo(to, this.label);
        return from;
    }

    @NotNull
    public final String getFromNode() {
        return this.fromNode;
    }

    @NotNull
    public final String getToNode() {
        return this.toNode;
    }

    @Nullable
    public final String getLabel() {
        return this.label;
    }

    public EdgeGenerator(@NotNull String fromNode, @NotNull String toNode, @Nullable String label) {
        Intrinsics.checkParameterIsNotNull((Object)fromNode, (String)"fromNode");
        Intrinsics.checkParameterIsNotNull((Object)toNode, (String)"toNode");
        this.fromNode = fromNode;
        this.toNode = toNode;
        this.label = label;
    }
}

