/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bootgraph.api.filter;

import com.atlassian.bootgraph.api.filter.GraphModelFilter;
import com.atlassian.bootgraph.api.model.Edge;
import com.atlassian.bootgraph.api.model.GraphModel;
import com.atlassian.bootgraph.api.model.Node;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J6\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/bootgraph/api/filter/InputPathFilter;", "Lcom/atlassian/bootgraph/api/filter/GraphModelFilter;", "startNode", "", "(Ljava/lang/String;)V", "addOutputsRecursively", "", "originalNode", "Lcom/atlassian/bootgraph/api/model/Node;", "newNode", "originalGraphModel", "Lcom/atlassian/bootgraph/api/model/GraphModel;", "newGraphModel", "visitedNodes", "", "applyTo", "originalModel", "bootgraph-core"})
public final class InputPathFilter
implements GraphModelFilter {
    private final String startNode;

    @Override
    @NotNull
    public GraphModel applyTo(@NotNull GraphModel originalModel) {
        Intrinsics.checkParameterIsNotNull((Object)originalModel, (String)"originalModel");
        GraphModel newModel = originalModel.shallowCopy();
        Node node = originalModel.getNode(this.startNode);
        if (node == null) {
            throw (Throwable)new IllegalStateException("Could not find node " + this.startNode + " in ApplicationModel. The node to base this filter on must exist!");
        }
        Node startNode = node;
        Node newStartNode = startNode.shallowCopy();
        this.addOutputsRecursively(startNode, newStartNode, originalModel, newModel);
        return newModel;
    }

    private final void addOutputsRecursively(Node originalNode, Node newNode, GraphModel originalGraphModel, GraphModel newGraphModel) {
        this.addOutputsRecursively(originalNode, newNode, originalGraphModel, newGraphModel, new HashSet());
    }

    private final void addOutputsRecursively(Node originalNode, Node newNode, GraphModel originalGraphModel, GraphModel newGraphModel, Set<Node> visitedNodes) {
        for (Edge output : originalNode.outgoingEdges()) {
            Node outputNode = output.getTo();
            if (visitedNodes.contains(outputNode)) {
                if (newGraphModel.getNode(outputNode.getName()) != null) {
                    Node node;
                    boolean bl = false;
                    boolean bl2 = false;
                    Node it = node;
                    boolean bl3 = false;
                    newNode.addEdgeTo(it);
                }
                continue;
            }
            Node newOutputNode = output.getTo().shallowCopy();
            newNode.addEdgeTo(newOutputNode, output.getLabel());
            newGraphModel.addNode(newOutputNode);
            visitedNodes.add(originalNode);
            this.addOutputsRecursively(output.getTo(), newOutputNode, originalGraphModel, newGraphModel, visitedNodes);
        }
    }

    public InputPathFilter(@NotNull String startNode) {
        Intrinsics.checkParameterIsNotNull((Object)startNode, (String)"startNode");
        this.startNode = startNode;
    }
}

