/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bootgraph.api;

import com.atlassian.bootgraph.api.filter.GraphModelFilter;
import com.atlassian.bootgraph.api.generator.EdgeGenerator;
import com.atlassian.bootgraph.api.generator.ExternalNodeGenerator;
import com.atlassian.bootgraph.api.generator.InternalNodeGenerator;
import com.atlassian.bootgraph.api.generator.NodeGenerator;
import com.atlassian.bootgraph.api.mapper.BeanMapper;
import com.atlassian.bootgraph.api.mapper.InternalBeanMapper;
import com.atlassian.bootgraph.api.matcher.BeanMatcher;
import com.atlassian.bootgraph.api.matcher.BeanNameMatcher;
import com.atlassian.bootgraph.api.matcher.QualifierMatcher;
import com.atlassian.bootgraph.api.matcher.TypeMatcher;
import com.atlassian.bootgraph.api.model.GraphModel;
import com.atlassian.bootgraph.graphviz.ExportConfiguration;
import com.atlassian.bootgraph.graphviz.GraphVizModelExporter;
import com.atlassian.bootgraph.spring.SpringNodeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0002#$B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004BM\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010!\u001a\u00020\"R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006%"}, d2={"Lcom/atlassian/bootgraph/api/BootGraph;", "", "builder", "Lcom/atlassian/bootgraph/api/BootGraph$Builder;", "(Lcom/atlassian/bootgraph/api/BootGraph$Builder;)V", "applicationName", "", "mappers", "", "Lcom/atlassian/bootgraph/api/matcher/BeanMatcher;", "Lcom/atlassian/bootgraph/api/mapper/BeanMapper;", "filter", "Lcom/atlassian/bootgraph/api/filter/GraphModelFilter;", "applicationContext", "Lorg/springframework/context/ConfigurableApplicationContext;", "exportConfig", "Lcom/atlassian/bootgraph/graphviz/ExportConfiguration;", "generators", "", "Lcom/atlassian/bootgraph/api/generator/NodeGenerator;", "(Ljava/lang/String;Ljava/util/Map;Lcom/atlassian/bootgraph/api/filter/GraphModelFilter;Lorg/springframework/context/ConfigurableApplicationContext;Lcom/atlassian/bootgraph/graphviz/ExportConfiguration;Ljava/util/List;)V", "getApplicationContext", "()Lorg/springframework/context/ConfigurableApplicationContext;", "getApplicationName", "()Ljava/lang/String;", "getExportConfig", "()Lcom/atlassian/bootgraph/graphviz/ExportConfiguration;", "getFilter", "()Lcom/atlassian/bootgraph/api/filter/GraphModelFilter;", "getGenerators", "()Ljava/util/List;", "getMappers", "()Ljava/util/Map;", "export", "", "Builder", "Companion", "bootgraph-core"})
public final class BootGraph {
    @NotNull
    private final String applicationName;
    @NotNull
    private final Map<BeanMatcher, BeanMapper> mappers;
    @Nullable
    private final GraphModelFilter filter;
    @NotNull
    private final ConfigurableApplicationContext applicationContext;
    @NotNull
    private final ExportConfiguration exportConfig;
    @NotNull
    private final List<NodeGenerator> generators;
    private static final Logger logger;
    public static final Companion Companion;

    public final void export() {
        SpringNodeFactory factory = SpringNodeFactory.Companion.defaultInstance(this.applicationName, this.applicationContext);
        Map<BeanMatcher, BeanMapper> map = this.mappers;
        boolean bl = false;
        Object object = map.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<BeanMatcher, BeanMapper> entry;
            Map.Entry<BeanMatcher, BeanMapper> entry2 = entry = object.next();
            boolean bl2 = false;
            BeanMatcher matcher = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            BeanMapper mapper = entry2.getValue();
            factory.addMapper(matcher, mapper);
        }
        for (NodeGenerator generator : this.generators) {
            factory.addGenerator(generator);
        }
        GraphModel graphModel = factory.createApplicationModel();
        GraphModelFilter graphModelFilter = this.filter;
        if (graphModelFilter != null) {
            object = graphModelFilter;
            boolean bl3 = false;
            bl = false;
            Object it = object;
            boolean bl4 = false;
            graphModel = graphModel.filter((GraphModelFilter)it);
        }
        GraphVizModelExporter exporter = new GraphVizModelExporter(this.exportConfig);
        logger.debug("about to export the following graph: {}", (Object)graphModel.toDebugString());
        exporter.export(graphModel);
    }

    @NotNull
    public final String getApplicationName() {
        return this.applicationName;
    }

    @NotNull
    public final Map<BeanMatcher, BeanMapper> getMappers() {
        return this.mappers;
    }

    @Nullable
    public final GraphModelFilter getFilter() {
        return this.filter;
    }

    @NotNull
    public final ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @NotNull
    public final ExportConfiguration getExportConfig() {
        return this.exportConfig;
    }

    @NotNull
    public final List<NodeGenerator> getGenerators() {
        return this.generators;
    }

    private BootGraph(String applicationName, Map<BeanMatcher, BeanMapper> mappers, GraphModelFilter filter, ConfigurableApplicationContext applicationContext, ExportConfiguration exportConfig, List<? extends NodeGenerator> generators) {
        this.applicationName = applicationName;
        this.mappers = mappers;
        this.filter = filter;
        this.applicationContext = applicationContext;
        this.exportConfig = exportConfig;
        this.generators = generators;
    }

    /* synthetic */ BootGraph(String string, Map map, GraphModelFilter graphModelFilter, ConfigurableApplicationContext configurableApplicationContext, ExportConfiguration exportConfiguration, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            graphModelFilter = null;
        }
        this(string, map, graphModelFilter, configurableApplicationContext, exportConfiguration, list);
    }

    private BootGraph(Builder builder) {
        String string = builder.getApplicationName();
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("Missing property 'applicationName'!");
        }
        Map<BeanMatcher, BeanMapper> map = builder.getMappers();
        GraphModelFilter graphModelFilter = builder.getFilter();
        ConfigurableApplicationContext configurableApplicationContext = builder.getApplicationContext();
        if (configurableApplicationContext == null) {
            throw (Throwable)new IllegalArgumentException("Missing property 'applicationContext'!");
        }
        ExportConfiguration exportConfiguration = builder.getExportConfig();
        if (exportConfiguration == null) {
            exportConfiguration = new ExportConfiguration();
        }
        this(string, map, graphModelFilter, configurableApplicationContext, exportConfiguration, builder.getGenerators());
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(BootGraph.class);
    }

    public /* synthetic */ BootGraph(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\"J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0016J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\bJ\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\bJ\u001e\u0010(\u001a\u00020\u0000\"\b\b\u0000\u0010)*\u00020\u00012\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H)0+J\u0016\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u001cJ\u0016\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\bJ\u001e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\bJ\u000e\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\bJ\u000e\u00104\u001a\u00020\u00002\u0006\u00103\u001a\u00020\bR\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u0003\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0003\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00065"}, d2={"Lcom/atlassian/bootgraph/api/BootGraph$Builder;", "", "()V", "<set-?>", "Lorg/springframework/context/ConfigurableApplicationContext;", "applicationContext", "getApplicationContext", "()Lorg/springframework/context/ConfigurableApplicationContext;", "", "applicationName", "getApplicationName", "()Ljava/lang/String;", "Lcom/atlassian/bootgraph/graphviz/ExportConfiguration;", "exportConfig", "getExportConfig", "()Lcom/atlassian/bootgraph/graphviz/ExportConfiguration;", "Lcom/atlassian/bootgraph/api/filter/GraphModelFilter;", "filter", "getFilter", "()Lcom/atlassian/bootgraph/api/filter/GraphModelFilter;", "generators", "", "Lcom/atlassian/bootgraph/api/generator/NodeGenerator;", "getGenerators", "()Ljava/util/List;", "mappers", "", "Lcom/atlassian/bootgraph/api/matcher/BeanMatcher;", "Lcom/atlassian/bootgraph/api/mapper/BeanMapper;", "getMappers", "()Ljava/util/Map;", "build", "Lcom/atlassian/bootgraph/api/BootGraph;", "export", "", "generator", "includeBeanWithName", "beanName", "includeBeanWithQualifier", "qualifier", "includeBeansOfType", "T", "beanClass", "Ljava/lang/Class;", "mapper", "matcher", "withEdge", "fromNode", "toNode", "label", "withExternalNode", "name", "withInternalNode", "bootgraph-core"})
    public static final class Builder {
        @Nullable
        private String applicationName;
        @Nullable
        private GraphModelFilter filter;
        @Nullable
        private ConfigurableApplicationContext applicationContext;
        @Nullable
        private ExportConfiguration exportConfig;
        @NotNull
        private final Map<BeanMatcher, BeanMapper> mappers = new HashMap();
        @NotNull
        private final List<NodeGenerator> generators = new ArrayList();

        @Nullable
        public final String getApplicationName() {
            return this.applicationName;
        }

        @Nullable
        public final GraphModelFilter getFilter() {
            return this.filter;
        }

        @Nullable
        public final ConfigurableApplicationContext getApplicationContext() {
            return this.applicationContext;
        }

        @Nullable
        public final ExportConfiguration getExportConfig() {
            return this.exportConfig;
        }

        @NotNull
        public final Map<BeanMatcher, BeanMapper> getMappers() {
            return this.mappers;
        }

        @NotNull
        public final List<NodeGenerator> getGenerators() {
            return this.generators;
        }

        @NotNull
        public final Builder applicationName(@NotNull String applicationName) {
            Intrinsics.checkParameterIsNotNull((Object)applicationName, (String)"applicationName");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.applicationName = applicationName;
            return builder;
        }

        @NotNull
        public final Builder mapper(@NotNull BeanMatcher matcher, @NotNull BeanMapper mapper) {
            Intrinsics.checkParameterIsNotNull((Object)matcher, (String)"matcher");
            Intrinsics.checkParameterIsNotNull((Object)mapper, (String)"mapper");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.mappers.put(matcher, mapper);
            return builder;
        }

        @NotNull
        public final Builder generator(@NotNull NodeGenerator generator) {
            Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.generators.add(generator);
            return builder;
        }

        @NotNull
        public final <T> Builder includeBeansOfType(@NotNull Class<T> beanClass) {
            Intrinsics.checkParameterIsNotNull(beanClass, (String)"beanClass");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            TypeMatcher<T> matcher = new TypeMatcher<T>(beanClass);
            InternalBeanMapper mapper = new InternalBeanMapper();
            $this$apply.mapper(matcher, mapper);
            return builder;
        }

        @NotNull
        public final Builder includeBeanWithName(@NotNull String beanName) {
            Intrinsics.checkParameterIsNotNull((Object)beanName, (String)"beanName");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            BeanNameMatcher matcher = new BeanNameMatcher(beanName);
            InternalBeanMapper mapper = new InternalBeanMapper();
            $this$apply.mapper(matcher, mapper);
            return builder;
        }

        @NotNull
        public final Builder includeBeanWithQualifier(@NotNull String qualifier) {
            Intrinsics.checkParameterIsNotNull((Object)qualifier, (String)"qualifier");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            QualifierMatcher matcher = new QualifierMatcher(qualifier);
            InternalBeanMapper mapper = new InternalBeanMapper();
            $this$apply.mapper(matcher, mapper);
            return builder;
        }

        @NotNull
        public final Builder withExternalNode(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.generator(new ExternalNodeGenerator(name));
            return builder;
        }

        @NotNull
        public final Builder withInternalNode(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.generator(new InternalNodeGenerator(name));
            return builder;
        }

        @NotNull
        public final Builder withEdge(@NotNull String fromNode, @NotNull String toNode, @NotNull String label) {
            Intrinsics.checkParameterIsNotNull((Object)fromNode, (String)"fromNode");
            Intrinsics.checkParameterIsNotNull((Object)toNode, (String)"toNode");
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.generator(new EdgeGenerator(fromNode, toNode, label));
            return builder;
        }

        @NotNull
        public final Builder withEdge(@NotNull String fromNode, @NotNull String toNode) {
            Intrinsics.checkParameterIsNotNull((Object)fromNode, (String)"fromNode");
            Intrinsics.checkParameterIsNotNull((Object)toNode, (String)"toNode");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.generator(new EdgeGenerator(fromNode, toNode, null));
            return builder;
        }

        @NotNull
        public final Builder filter(@NotNull GraphModelFilter filter) {
            Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.filter = filter;
            return builder;
        }

        @NotNull
        public final Builder applicationContext(@NotNull ConfigurableApplicationContext applicationContext) {
            Intrinsics.checkParameterIsNotNull((Object)applicationContext, (String)"applicationContext");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.applicationContext = applicationContext;
            return builder;
        }

        @NotNull
        public final Builder exportConfig(@NotNull ExportConfiguration exportConfig) {
            Intrinsics.checkParameterIsNotNull((Object)exportConfig, (String)"exportConfig");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.exportConfig = exportConfig;
            return builder;
        }

        @NotNull
        public final BootGraph build() {
            return new BootGraph(this, null);
        }

        public final void export() {
            new BootGraph(this, null).export();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/bootgraph/api/BootGraph$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "builder", "Lcom/atlassian/bootgraph/api/BootGraph$Builder;", "bootgraph-core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

