/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.solrlib;

import io.redlink.utils.PathUtils;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.slf4j.LoggerFactory;

public interface SolrCoreDescriptor {
    default public int getNumShards() {
        return 1;
    }

    default public int getReplicationFactor() {
        return 1;
    }

    default public String getCoreName() {
        return this.getClass().getSimpleName();
    }

    public void initCoreDirectory(Path var1, Path var2) throws IOException;

    default public void onCoreCreated(SolrClient solrClient) throws IOException, SolrServerException {
    }

    default public void onCoreStarted(SolrClient solrClient) throws IOException, SolrServerException {
    }

    public static void unpackSolrCoreDir(Path solrCoreBundle, Path solrCoreDir) throws IOException {
        LoggerFactory.getLogger(SolrCoreDescriptor.class).debug("Unpacking SolrCore directory {} to {}", (Object)solrCoreBundle, (Object)solrCoreDir);
        try (Stream<Path> pathStream = Files.find(solrCoreBundle, Integer.MAX_VALUE, (p, a) -> Files.isRegularFile(p, new LinkOption[0]) && Files.isReadable(p) && "core.properties".equals(String.valueOf(p.getFileName())), new FileVisitOption[0]);){
            Optional<Path> coreProperties = pathStream.min(Comparator.comparingInt(Path::getNameCount));
            Path sourceDir = coreProperties.orElseThrow(() -> new IllegalArgumentException("Invalid solrCoreBundle '" + solrCoreBundle + "': no core.properties found")).getParent();
            PathUtils.copyRecursive((Path)sourceDir, (Path)solrCoreDir);
        }
    }

    public static void unpackSolrCoreZip(Path solrCoreBundle, Path solrHome) throws IOException {
        SolrCoreDescriptor.unpackSolrCoreZip(solrCoreBundle, solrHome, null);
    }

    public static void unpackSolrCoreZip(Path solrCoreBundle, Path solrHome, ClassLoader classLoader) throws IOException {
        String contentType = Files.probeContentType(solrCoreBundle);
        if ("application/zip".equals(contentType) || contentType == null && StringUtils.endsWithAny((CharSequence)solrCoreBundle.getFileName().toString(), (CharSequence[])new CharSequence[]{".zip", ".jar"})) {
            LoggerFactory.getLogger(SolrCoreDescriptor.class).debug("Unpacking SolrCore zip {} to {}", (Object)solrCoreBundle, (Object)solrHome);
            try (FileSystem fs = FileSystems.newFileSystem(solrCoreBundle, classLoader);){
                SolrCoreDescriptor.unpackSolrCoreDir(fs.getPath("/", new String[0]), solrHome);
            }
        } else {
            throw new IllegalArgumentException("Packaged solrCoreBundle '" + solrCoreBundle + "' has unsupported type: " + contentType);
        }
    }
}

